/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.cli;

import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;

public class CliConstants {
    public static final String ARGS_PREFIX = "-";

    public static class DESC {
        public static final String APP = "Application name, case-sensitive";
        public static final String BRANCH = "Branch name, case-sensitive.";
        public static final String BUILD = "Build id, case-sensitive. Should be unique between builds.";
        public static final String BUILD_SESSION_ID = "Provide build session id manually, case-sensitive.";
        public static final String BUILD_SESSION_ID_FILE = "Path to a file to save the build session id in (default: <user.dir>/buildSessionId.txt).";
        public static final String BUILDEND = "Flag to indicate build-end mode";
        public static final String BUILD_OK = "Indicates build success";
        public static final String BUILD_FAILED = "Indicates build failure";
        public static final String COMPONENT_DELETE = "Flag to indicate integration build components delete mode";
        public static final String COMPONENT_FILE = "A path to a json file with components data in the following format: [{\"appName\":\"\",\"branch\":\"\",\"build\":\"\"},{...}]";
        public static final String COMPONENT_IDS = "Comma-separated list of component build session ids(a single value may be provided)";
        public static final String COMPONENT_UPDATE = "Flag to indicate integration build components update mode";
        public static final String CONFIG = "Flag to indicate configuration mode";
        public static final String CONFIG_FILES_EXCLUDED = "For .NET agents only - Comma-separated list of files to exclude from scan. Supports wildcards (* = any string, ? = any character). For example: '?app.dll, *.dll'";
        public static final String CONFIG_FILES_INCLUDED = "For .NET agents only - Comma-separated list of files to scan. Supports wildcards (* = any string, ? = any character). For example:'?app.dll, *.dll'";
        public static final String CUSTOM_FILTER_FILE = "A path to custom exclusions filter file in json format";
        public static final String GRADLE_INTEGRATE = "Flag to indicate Gradle build script integration mode";
        public static final String GRADLE_PLUGIN_VERSION = "Version of the sealights-gradle-plugin to be used";
        public static final String GRADLE_RESTORE = "Flag to indicate Gradle build script restoration mode";
        public static final String GRADLE_WSPACE = "Path to the workspace where the root projects build.gradle file exists";
        public static final String HELP = "Show this help page";
        public static final String JSON_CONFIG_FILE = "The path to json file that contains parameters for SeaLights";
        public static final String LATEST_COMMIT = "The latest commit SHA";
        public static final String MAVEN_LOCAL_REPO_PATH = "Path to the maven local repository, usually ${user.home}/.m2/repository";
        public static final String MODIFY_PARENT_POM = "Flag to enable parent pom modification in -pom mode";
        public static final String MODULES = "Flag to indicate show modules mode";
        public static final String NAMESPACES_EXCLUDED = "For .NET agents only - Comma-separated list of namespaces to exclude from scan. Supports wildcards (* = any string, ? = any character). For example: 'com.example.* ,io.*.demo, com.?ello.world'";
        public static final String NAMESPACES_INCLUDED = "For .NET agents only - Comma-separated list of namespaces to scan. Supports wildcards (* = any string, ? = any character). For example:'com.example.* ,io.*.demo, com.?ello.world'";
        public static final String NON_ZERO_CODE = "Indicates that the Build Scanner should return with error code in case of scan failure. On: return 1, Off: return 0";
        public static final String PACKAGES_EXCLUDED = "Comma-separated list of packages to exclude from scan. Supports wildcards (* = any string, ? = any character). For example: 'com.example.* ,io.*.demo, com.?ello.world'";
        public static final String PACKAGES_INCLUDED = "Comma-separated list of packages to scan. Supports wildcards (* = any string, ? = any character). For example:'com.example.* ,io.*.demo, com.?ello.world'";
        public static final String PROJECTS_EXCLUDED = "Comma-separated list of Gradle (sub)projects to exclude from SeaLights integration. Overrides 'includedProjects'";
        public static final String PROJECTS_INCLUDED = "Comma-separated list of Gradle (sub)projects to include in SeaLights integration. When empty, all projects are included";
        public static final String POM = "Flag to indicate pom integration mode";
        public static final String POM_WSPACE = "Path to the workspace where the pom files exists";
        public static final String POM_RECURSIVE = "Path to the workspace where the pom files exists";
        public static final String POM_CONFIG_FILE = "The path to json file that contains parameters for pom file";
        public static final String POM_PLUGIN_VERSION = "Version of the sealights-maven-plugin to be used";
        public static final String PRCONFIG = "Flag to indicate pull-request configuration mode";
        public static final String PROXY = "Proxy server (optional, must be a valid URL. in the form of 'http://127.0.0.1:3333')";
        public static final String PULL_REQUEST_NUMBER = "The pull request number";
        public static final String REPO_URL = "The repository url, where pull request was created";
        public static final String REPO_CONFIG = "The Gradle configuration of repositories used for Gradle integration. The passed code is not validated";
        public static final String RESTORE = "Flag to indicate pom restore mode";
        public static final String SCAN = "Flag to indicate scan mode";
        public static final String SCAN_FILES_EXCLUDED = "Comma-separated list of files to exclude from scan. Supports wildcards (* = any string, ? = any character). For example: '*-with-dependencies.jar , bad-bad?.war, *-source.jar'";
        public static final String SCAN_FILES_INCLUDED = "Comma-separated list of files to scan. Supports wildcards (* = any string, ? = any character). For example: 'original-*.jar ,demo?.jar";
        public static final String TARGET_BRANCH = "A branch the pull request is compared with";
        public static final String TOKEN = "Token (mandatory. Can also be provided by 'tokenfile' argument). Case-sensitive.";
        public static final String TOKEN_FILE = "A path to a file where the program can find the token. Case-sensitive.";
        public static final String GRADLE_USE_ONLY_PROJECT_REPO_SECTION = "Flag to skip generating repositories section and use only pre-defined repos for build.gradle file";
    }

    public static class ARGS {
        public static final String APP = "appname";
        public static final String BUILD_SESSION_ID = "buildsessionid";
        public static final String BUILD_SESSION_ID_FILE = "buildsessionidfile";
        public static final String BUILD_OK = "ok";
        public static final String BUILD_FAILED = "failed";
        public static final String COMPONENT_FILE = "componentfile";
        public static final String COMPONENT_FILE_SHORT = "cf";
        public static final String COMPONENT_IDS = "componentids";
        public static final String COMPONENT_IDS_SHORT = "cs";
        public static final String CONFIG_BRANCH = "branchname";
        public static final String CONFIG_BUILD = "buildname";
        public static final String CONFIG_FILE = "configfile";
        public static final String CONFIG_FILES_EXCLUDED = "excludedFilePatterns";
        public static final String CONFIG_FILES_EXCLUDED_SHORT = "efp";
        public static final String CONFIG_FILES_INCLUDED = "includedFilePatterns";
        public static final String CONFIG_FILES_INCLUDED_SHORT = "ifp";
        public static final String CUSTOMER = "customerid";
        public static final String CUSTOM_FILTER_FILE = "customFilterFile";
        public static final String DEPENDENCIES_FILE = "dependenciesFile";
        public static final String DEPENDENCIES_FILE_SHORT = "df";
        public static final String NON_ZERO_CODE = "enableNoneZeroErrorCode";
        public static final String HELP_SHORT = "h";
        public static final String IS_LAST_MODULE = "isLastModule";
        public static final String LATEST_COMMIT = "latestCommit";
        public static final String MAVEN_LOCAL_REPO_PATH = "mavenLocalRepoPath";
        public static final String MODIFY_PARENT_POM = "modifyParentPom";
        public static final String MODULE_NAME = "moduleName";
        public static final String NAMESPACES_EXCLUDED = "excludedNamespaces";
        public static final String NAMESPACES_EXCLUDED_SHORT = "en";
        public static final String NAMESPACES_INCLUDED = "includedNamespaces";
        public static final String NAMESPACES_INCLUDED_SHORT = "in";
        public static final String NO_PROPS_FILE = "noPropertiesFile";
        public static final String PACKAGES_EXCLUDED = "packagesexcluded";
        public static final String PACKAGES_EXCLUDED_SHORT = "pe";
        public static final String PACKAGES_INCLUDED = "packagesincluded";
        public static final String PACKAGES_INCLUDED_SHORT = "pi";
        public static final String PATH_TO_META_JSON = "pathToMetaJson";
        public static final String PLUGIN_VERSION = "pluginversion";
        public static final String PROJECTS_EXCLUDED = "excludedProjects";
        public static final String PROJECTS_INCLUDED = "includedProjects";
        public static final String PROPS_FILE = "propertiesFileName";
        public static final String PROXY = "proxy";
        public static final String PULL_REQUEST_NUMBER = "pullRequestNumber";
        public static final String RECURSIVE = "recursive";
        public static final String RECURSIVE_SHORT = "r";
        public static final String REPO_URL = "repoUrl";
        public static final String SCAN_BRANCH = "branch";
        public static final String SCAN_BUILD = "build";
        public static final String SCAN_REPOSITORY_URL = "repositoryUrl";
        public static final String SCAN_PULL_REQUEST_NUMBER = "pullRequestNumber";
        public static final String SCAN_LATEST_COMMIT = "latestCommit";
        public static final String SCAN_TARGET_BRANCH = "targetBranch";
        public static final String SCAN_FILES_EXCLUDED = "filesexcluded";
        public static final String SCAN_FILES_EXCLUDED_SHORT = "fe";
        public static final String SCAN_FILES_INCLUDED = "filesincluded";
        public static final String SCAN_FILES_INCLUDED_SHORT = "fi";
        public static final String SCM = "scm";
        public static final String SCM_BASE_URL = "scmBaseUrl";
        public static final String SCM_PROVIDER = "scmProvider";
        public static final String SCM_VERSION = "scmVersion";
        public static final String SEND_CONTRIBUTORS = "sendContributors";
        public static final String SERVER = "server";
        public static final String SOURCE_PATH = "sourcePath";
        public static final String TARGET_BRANCH = "targetBranch";
        public static final String TOKEN = "token";
        public static final String TOKEN_FILE = "tokenfile";
        public static final String INTEGRATION_TOKEN = "integrationToken";
        public static final String WSPACE = "workspacepath";
        public static final String POM_APP = "appName";
        public static final String POM_BUILD = "buildName";
        public static final String POM_BRANCH = "branchName";
        public static final String POM_REPO_URL = "repoUrl";
        public static final String POM_PULL_REQUEST_NUMBER = "pullRequestNumber";
        public static final String POM_LATEST_COMMIT = "latestCommit";
        public static final String POM_TARGET_BRANCH = "targetBranch";
        public static final String POM_PACKAGES_INCLUDED = "packagesIncluded";
        public static final String REPO_CONFIG = "repoConfig";
        public static final String USE_ONLY_PROJECT_REPO_SECTION = "useOnlyProjectRepoSection";
    }

    public static class MODES {
        public static final String CONFIG = ModesOptions.ExecMode.CONFIG.getValue();
        public static final String PRCONFIG = ModesOptions.ExecMode.PRCONFIG.getValue();
        public static final String SCAN = ModesOptions.ExecMode.SCAN.getValue();
        public static final String MODULES = ModesOptions.ExecMode.MODULES.getValue();
        public static final String POM = ModesOptions.ExecMode.POM.getValue();
        public static final String RESTORE = ModesOptions.ExecMode.RESTORE.getValue();
        public static final String BUILDEND = ModesOptions.ExecMode.BUILDEND.getValue();
        public static final String COMPONENT_UPDATE = ModesOptions.ExecMode.COMPONENT_UPDATE.getValue();
        public static final String COMPONENT_DELETE = ModesOptions.ExecMode.COMPONENT_DELETE.getValue();
    }
}

