/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main.cli;

import io.sealights.onpremise.agents.buildscanner.main.cli.BuildendArgsParser;
import io.sealights.onpremise.agents.buildscanner.main.cli.ComponentModeArgsParser;
import io.sealights.onpremise.agents.buildscanner.main.cli.ConfigModeArgsParser;
import io.sealights.onpremise.agents.buildscanner.main.cli.ExecModeArguments;
import io.sealights.onpremise.agents.buildscanner.main.cli.GradleIntegrationArgsParser;
import io.sealights.onpremise.agents.buildscanner.main.cli.GradleRestorationArgsParser;
import io.sealights.onpremise.agents.buildscanner.main.cli.ModeArgsParser;
import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;
import io.sealights.onpremise.agents.buildscanner.main.cli.PomIntegrationArgsParser;
import io.sealights.onpremise.agents.buildscanner.main.cli.PomRestoreArgsParser;
import io.sealights.onpremise.agents.buildscanner.main.cli.PrConfigModeArgsParser;
import io.sealights.onpremise.agents.buildscanner.main.cli.ScanModeArgsParser;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.slf4j.Logger;

public class ArgsParserWrapper {
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static Logger LOG = LogFactory.getLogger(ArgsParserWrapper.class);
    private Map<ModesOptions.ExecMode, ModeArgsParser<?>> argsParsers = new HashMap();
    private CommandLineParser parser = new DefaultParser();

    public ArgsParserWrapper() {
        this.argsParsers.put(ModesOptions.ExecMode.SCAN, new ScanModeArgsParser(this.parser, ModesOptions.ExecMode.SCAN));
        this.argsParsers.put(ModesOptions.ExecMode.MODULES, new ScanModeArgsParser(this.parser, ModesOptions.ExecMode.MODULES));
        this.argsParsers.put(ModesOptions.ExecMode.CONFIG, new ConfigModeArgsParser(this.parser));
        this.argsParsers.put(ModesOptions.ExecMode.PRCONFIG, new PrConfigModeArgsParser(this.parser));
        this.argsParsers.put(ModesOptions.ExecMode.POM, new PomIntegrationArgsParser(this.parser));
        this.argsParsers.put(ModesOptions.ExecMode.RESTORE, new PomRestoreArgsParser(this.parser));
        this.argsParsers.put(ModesOptions.ExecMode.GRADLE_INTEGRATE, new GradleIntegrationArgsParser(this.parser));
        this.argsParsers.put(ModesOptions.ExecMode.GRADLE_RESTORE, new GradleRestorationArgsParser(this.parser));
        this.argsParsers.put(ModesOptions.ExecMode.BUILDEND, new BuildendArgsParser(this.parser));
        this.argsParsers.put(ModesOptions.ExecMode.COMPONENT_UPDATE, new ComponentModeArgsParser(this.parser, ModesOptions.ExecMode.COMPONENT_UPDATE));
        this.argsParsers.put(ModesOptions.ExecMode.COMPONENT_DELETE, new ComponentModeArgsParser(this.parser, ModesOptions.ExecMode.COMPONENT_DELETE));
    }

    public ExecModeArguments parse(String[] args) {
        CommandLine cmdLine;
        ModesOptions mo = new ModesOptions();
        Options options = mo.getOptions();
        try {
            cmdLine = this.parser.parse(options, args, true);
        }
        catch (Exception e) {
            CONSOLE_LOG.println("\n" + e.getMessage());
            LOG.error(e.getMessage());
            this.displayNoModeSelectedView(options);
            return null;
        }
        ModesOptions.ExecMode execMode = this.detectExecMode(cmdLine);
        if (execMode == null) {
            this.displayNoModeSelectedView(options);
            return null;
        }
        return this.parseArgs(args, execMode);
    }

    private ModesOptions.ExecMode detectExecMode(CommandLine cmdLine) {
        ModesOptions.ExecMode detected = null;
        for (ModesOptions.ExecMode e : ModesOptions.ExecMode.values()) {
            if (!cmdLine.hasOption(e.getValue())) continue;
            if (detected != null) {
                return null;
            }
            detected = e;
        }
        return detected;
    }

    private ExecModeArguments parseArgs(String[] args, ModesOptions.ExecMode execMode) {
        ExecModeArguments execArgs = null;
        if (execMode == ModesOptions.ExecMode.HELP) {
            this.displayHelpView();
        } else {
            ModeArgsParser<?> argsParser = this.argsParsers.get((Object)execMode);
            if (argsParser != null) {
                execArgs = (ExecModeArguments)argsParser.parse(args);
            }
        }
        if (execArgs != null) {
            LOG.debug("Created from cli: {}", (Object)execArgs);
        }
        return execArgs;
    }

    protected void displayHelpView() {
        for (ModeArgsParser<?> argsParser : this.argsParsers.values()) {
            argsParser.displayHelpView();
        }
    }

    protected void displayNoModeSelectedView(Options options) {
        CONSOLE_LOG.info("mode argument is missing; please provide one of the following modes:{}\n", (Object)Arrays.asList(ModesOptions.ExecMode.values()));
        new HelpFormatter().printHelp("Type '-help' for more information.", "", options, "", true);
    }

    @Generated
    public Map<ModesOptions.ExecMode, ModeArgsParser<?>> getArgsParsers() {
        return this.argsParsers;
    }

    @Generated
    public CommandLineParser getParser() {
        return this.parser;
    }

    @Generated
    public void setArgsParsers(Map<ModesOptions.ExecMode, ModeArgsParser<?>> argsParsers) {
        this.argsParsers = argsParsers;
    }

    @Generated
    public void setParser(CommandLineParser parser) {
        this.parser = parser;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArgsParserWrapper)) {
            return false;
        }
        ArgsParserWrapper other = (ArgsParserWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<ModesOptions.ExecMode, ModeArgsParser<?>> this$argsParsers = this.getArgsParsers();
        Map<ModesOptions.ExecMode, ModeArgsParser<?>> other$argsParsers = other.getArgsParsers();
        if (this$argsParsers == null ? other$argsParsers != null : !((Object)this$argsParsers).equals(other$argsParsers)) {
            return false;
        }
        CommandLineParser this$parser = this.getParser();
        CommandLineParser other$parser = other.getParser();
        return !(this$parser == null ? other$parser != null : !this$parser.equals(other$parser));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArgsParserWrapper;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<ModesOptions.ExecMode, ModeArgsParser<?>> $argsParsers = this.getArgsParsers();
        result = result * 59 + ($argsParsers == null ? 43 : ((Object)$argsParsers).hashCode());
        CommandLineParser $parser = this.getParser();
        result = result * 59 + ($parser == null ? 43 : $parser.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ArgsParserWrapper(argsParsers=" + this.getArgsParsers() + ", parser=" + this.getParser() + ")";
    }
}

