/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.main;

import io.sealights.onpremise.agents.buildscanner.bootstrap.BuildAgentBoostraper;
import io.sealights.onpremise.agents.buildscanner.bootstrap.UpgradeConfigurationBuilder;
import io.sealights.onpremise.agents.buildscanner.execmode.ExecutorFactory;
import io.sealights.onpremise.agents.buildscanner.execmode.ModeExecutor;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.ScanModeExecutor;
import io.sealights.onpremise.agents.buildscanner.main.AppConstants;
import io.sealights.onpremise.agents.buildscanner.main.cli.ArgsParserWrapper;
import io.sealights.onpremise.agents.buildscanner.main.cli.ExecModeArguments;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.buildscanner.main.cli.config.ConfigModeArguments;
import io.sealights.onpremise.agents.infra.configuration.UpgradeConfiguration;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.token.TokenData;
import io.sealights.onpremise.agents.infra.token.TokenValueFormatter;
import io.sealights.onpremise.agents.logback.LogbackLogManager;
import org.slf4j.Logger;

public class App {
    private static Logger LOG;
    private static ConsoleLogger CONSOLE_LOG;
    private static String BUILD_SCANNER_ERROR;

    public static void main(String[] args) {
        CONSOLE_LOG = LogFactory.createConsoleLogger();
        LOG = LogFactory.getLogger(App.class);
        String argLine = String.format("input arguments: %s", TokenValueFormatter.toJson(args));
        CONSOLE_LOG.status(argLine);
        LOG.info(argLine);
        ExecModeArguments modeArguments = null;
        ModeExecutor<?> executor = null;
        try {
            ArgsParserWrapper apw = new ArgsParserWrapper();
            modeArguments = apw.parse(args);
            if (modeArguments == null) {
                return;
            }
            CONSOLE_LOG.status("Running version " + App.getAppVersion());
            LOG.debug("parsed scan arguments:\n{}", (Object)JsonObjectMapper.toJson(modeArguments, true));
            executor = ExecutorFactory.create(modeArguments);
            boolean isSuccess = false;
            if (executor.isTokenRelevant()) {
                TokenData tokenData = executor.searchAndExtractTokenData(modeArguments);
                if (tokenData.isValid()) {
                    if (App.tryUpgradeToRecommendedVersion(tokenData, modeArguments, args)) {
                        return;
                    }
                } else {
                    CONSOLE_LOG.error("cannot proceed without valid token");
                }
            }
            if (!(isSuccess = executor.execute())) {
                CONSOLE_LOG.error("mode '%s' was executed with error, please fix the problem and retry", (Object)modeArguments.getExecMode());
            }
            if (!isSuccess && modeArguments.isEnableNoneZeroErrorCode()) {
                System.exit(1);
            }
        }
        catch (Exception e) {
            App.exitOnError(executor, modeArguments, e);
        }
    }

    public static String getAppVersion() {
        return App.class.getPackage().getImplementationVersion();
    }

    private static boolean tryUpgradeToRecommendedVersion(TokenData tokenData, ExecModeArguments modeArguments, String[] appArgs) {
        if (!tokenData.isValid()) {
            LOG.info("Upgrade cannot be done due to invalid token");
            return false;
        }
        if (!BuildAgentBoostraper.isUpgradeEnable()) {
            LOG.info("Upgrade is disable");
            return false;
        }
        UpgradeConfiguration upgradeConfiguration = UpgradeConfigurationBuilder.createUpgradeConfiguration(modeArguments, tokenData);
        LOG.info(String.format("Start upgrade with configuration:%s", upgradeConfiguration));
        boolean upgraded = BuildAgentBoostraper.runRecommendedAgent(upgradeConfiguration, appArgs);
        if (upgraded) {
            return true;
        }
        LOG.error("Upgrade was not done, proceed with the installed version");
        return false;
    }

    private static void exitOnError(ModeExecutor<?> executor, ExecModeArguments modeArguments, Exception e) {
        CONSOLE_LOG.error(BUILD_SCANNER_ERROR, e);
        if (executor instanceof ScanModeExecutor) {
            ((ScanModeExecutor)executor).notifyUnexpectedError(e);
        } else {
            LOG.error(BUILD_SCANNER_ERROR, e);
        }
        if (App.isEnableNoneZeroErrorCode(modeArguments)) {
            LOG.error("Failed with exit code 1.");
            System.exit(1);
        }
        LOG.error("Failed with exit code 0.");
        System.exit(0);
    }

    private static boolean isEnableNoneZeroErrorCode(Object arguments) {
        if (arguments == null) {
            return false;
        }
        return arguments instanceof ScanModeArguments && ((ScanModeArguments)arguments).isEnableNoneZeroErrorCode() || arguments instanceof ConfigModeArguments && ((ConfigModeArguments)arguments).isEnableNoneZeroErrorCode();
    }

    static {
        BUILD_SCANNER_ERROR = "Build scanner failed with error:";
        LogbackLogManager.start();
        ConsoleLogger.initComponentTag(AppConstants.SL_BUILD_SCANNER_TAG);
    }
}

