/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.integbuild.component;

import io.sealights.onpremise.agents.buildscanner.integbuild.component.Component;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.List;

public class ComponentsValidator {
    public static String APP_NAME_FIELD = "appName";
    public static String BRANCH_FIELD = "branch";
    public static String BUILD_FIELD = "build";
    private static String MISSING_DATA_ERR_FMT = "invalid component input:'%s' - a property '%s' should be defined";
    private static String EXTRA_DATA_ERR_FMT = "invalid component input:'%s', if buildSessionId is provided, none of app-branch-build combo should be given";
    private ValidationResult validationResult;

    public ValidationResult validate(List<Component> components) {
        this.validationResult = new ValidationResult();
        for (Component entry : components) {
            if (entry.hasBuildSessionIdDefined() && !this.isComboEmpty(entry)) {
                this.validationResult.addError(ComponentsValidator.buildExtraFieldMsg(entry));
            }
            if (entry.hasBuildSessionIdDefined()) continue;
            this.validateTripple(entry);
        }
        return this.validationResult;
    }

    public static String buildMissingFieldMsg(Component invalidComponent, String invalidField) {
        return String.format(MISSING_DATA_ERR_FMT, JsonObjectMapper.toJson(invalidComponent), invalidField);
    }

    public static String buildExtraFieldMsg(Component invalidComponent) {
        return String.format(EXTRA_DATA_ERR_FMT, JsonObjectMapper.toJson(invalidComponent));
    }

    private boolean validateTripple(Component entry) {
        boolean invalid = false;
        if (!this.validateFieldDefined(APP_NAME_FIELD, entry.getAppName(), entry)) {
            invalid = false;
        }
        if (this.validateFieldDefined(BRANCH_FIELD, entry.getBranch(), entry)) {
            invalid = false;
        }
        if (this.validateFieldDefined(BUILD_FIELD, entry.getBuild(), entry)) {
            invalid = false;
        }
        return invalid;
    }

    private boolean validateFieldDefined(String name, String value, Component entry) {
        if (StringUtils.isNullOrEmpty(value)) {
            this.validationResult.addError(ComponentsValidator.buildMissingFieldMsg(entry, name));
            return false;
        }
        return true;
    }

    private boolean isComboEmpty(Component entry) {
        return StringUtils.isNullOrEmpty(entry.getAppName()) && StringUtils.isNullOrEmpty(entry.getBranch()) && StringUtils.isNullOrEmpty(entry.getBuild());
    }
}

