/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.integbuild.component;

import io.sealights.onpremise.agents.buildscanner.integbuild.component.Component;
import io.sealights.onpremise.agents.buildscanner.integbuild.component.ComponentArguments;
import io.sealights.onpremise.agents.buildscanner.integbuild.component.ComponentsValidator;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.env.DefaultDirs;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;

public class ComponentsInputHandler {
    public static String INVALID_VALUE_ERR_FMT = "Invalid component input:'%s', expected format is AppName@Branch@Build or buildSessionId";
    public static String COMPONENTS_FILE_NOT_FOUND_FMT = "Components file wasn't found in the specified path: '%s'; working directory:'" + DefaultDirs.WORKING_DIR + "'";
    public static String NO_INPUT_ERR_FMT = "Components input was not provied";
    public static String INVALID_COMPONENTS_FILE_ERR_FMT = "Invalid components file '%s' - read error: '%s'";
    private ComponentArguments arguments;
    private boolean inputDemanded;
    private List<Component> components = new ArrayList<Component>();
    private ValidationResult validationResult = new ValidationResult();

    public ComponentsInputHandler(ComponentArguments dependenciesArguments, boolean inputDemanded) {
        this.arguments = dependenciesArguments;
        this.inputDemanded = inputDemanded;
    }

    public ValidationResult processAndValidate() {
        this.fillDependencies();
        this.validate();
        return this.validationResult;
    }

    protected void fillDependencies() {
        if (this.arguments.hasValuesInput()) {
            this.parseValues();
        } else if (this.arguments.hasFileInput()) {
            this.readComponentsFromFile();
        }
    }

    protected void validate() {
        if (!this.validationResult.isValid()) {
            return;
        }
        if (this.components.isEmpty()) {
            if (this.inputDemanded) {
                this.validationResult.addError(NO_INPUT_ERR_FMT);
            }
            return;
        }
        this.validationResult.add(new ComponentsValidator().validate(this.components));
    }

    private void parseValues() {
        for (String val : this.arguments.getValues()) {
            Component component = this.parseInputValue(val);
            this.components.add(component);
        }
    }

    private void readComponentsFromFile() {
        File componentsFile = new File(this.arguments.getFileName());
        if (!componentsFile.exists() || componentsFile.isDirectory()) {
            this.validationResult.addError(this.buildFileNotFoundMsg());
            return;
        }
        try {
            Component[] comps = JsonObjectMapper.toObject(componentsFile, Component[].class);
            this.components.addAll(Arrays.asList(comps));
        }
        catch (Exception e) {
            this.validationResult.addError(this.buildFileReadErrorMsg(e));
        }
    }

    public String buildFileNotFoundMsg() {
        return String.format(COMPONENTS_FILE_NOT_FOUND_FMT, this.arguments.getFileName());
    }

    public String buildFileReadErrorMsg(Exception e) {
        return String.format(INVALID_COMPONENTS_FILE_ERR_FMT, this.arguments.getFileName(), e.getMessage());
    }

    @Deprecated
    public Component parseInputValue(String value) {
        String SEPARATOR = "@";
        String[] tokens = value.split("@");
        Component parsedData = null;
        switch (tokens.length) {
            case 3: {
                String appname = tokens[0];
                String branch = tokens[1];
                String build = tokens[2];
                parsedData = new Component(appname, branch, build);
                break;
            }
            case 1: {
                parsedData = new Component(value);
                break;
            }
            default: {
                this.validationResult.addError(String.format(INVALID_VALUE_ERR_FMT, value));
            }
        }
        return parsedData;
    }

    @Generated
    public ComponentArguments getArguments() {
        return this.arguments;
    }

    @Generated
    public boolean isInputDemanded() {
        return this.inputDemanded;
    }

    @Generated
    public List<Component> getComponents() {
        return this.components;
    }

    @Generated
    public ValidationResult getValidationResult() {
        return this.validationResult;
    }

    @Generated
    public void setArguments(ComponentArguments arguments) {
        this.arguments = arguments;
    }

    @Generated
    public void setInputDemanded(boolean inputDemanded) {
        this.inputDemanded = inputDemanded;
    }

    @Generated
    public void setComponents(List<Component> components) {
        this.components = components;
    }

    @Generated
    public void setValidationResult(ValidationResult validationResult) {
        this.validationResult = validationResult;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComponentsInputHandler)) {
            return false;
        }
        ComponentsInputHandler other = (ComponentsInputHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ComponentArguments this$arguments = this.getArguments();
        ComponentArguments other$arguments = other.getArguments();
        if (this$arguments == null ? other$arguments != null : !((Object)this$arguments).equals(other$arguments)) {
            return false;
        }
        if (this.isInputDemanded() != other.isInputDemanded()) {
            return false;
        }
        List<Component> this$components = this.getComponents();
        List<Component> other$components = other.getComponents();
        if (this$components == null ? other$components != null : !((Object)this$components).equals(other$components)) {
            return false;
        }
        ValidationResult this$validationResult = this.getValidationResult();
        ValidationResult other$validationResult = other.getValidationResult();
        return !(this$validationResult == null ? other$validationResult != null : !((Object)this$validationResult).equals(other$validationResult));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComponentsInputHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ComponentArguments $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : ((Object)$arguments).hashCode());
        result = result * 59 + (this.isInputDemanded() ? 79 : 97);
        List<Component> $components = this.getComponents();
        result = result * 59 + ($components == null ? 43 : ((Object)$components).hashCode());
        ValidationResult $validationResult = this.getValidationResult();
        result = result * 59 + ($validationResult == null ? 43 : ((Object)$validationResult).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ComponentsInputHandler(arguments=" + this.getArguments() + ", inputDemanded=" + this.isInputDemanded() + ", components=" + this.getComponents() + ", validationResult=" + this.getValidationResult() + ")";
    }
}

