/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.groovy;

import io.sealights.onpremise.agents.buildscanner.groovy.ArgumentType;
import io.sealights.onpremise.agents.buildscanner.groovy.GroovyUtils;
import io.sealights.onpremise.agents.commons.instrument.utils.HashingUtils;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;

public class MethodSourceInfo {
    private String classname;
    private String sourceCode;
    private String hash;
    private String name;
    private List<ArgumentType> argumentTypes;
    private HashingUtils hashingUtils = new HashingUtils();
    private boolean generated;

    public MethodSourceInfo(MethodNode methodNode) {
        this.classname = methodNode.getDeclaringClass().getName();
        this.sourceCode = GroovyUtils.getSourceCode(methodNode.getCode());
        this.hash = this.getSourceCodeHash(methodNode);
        this.name = methodNode.getName();
        this.argumentTypes = this.extractArgumentTypes(methodNode.getParameters());
        this.generated = methodNode.isSynthetic() || methodNode.getLineNumber() == -1;
    }

    private String getSourceCodeHash(MethodNode methodNode) {
        try {
            return GroovyUtils.getSourceCodeHash(methodNode.getCode());
        }
        catch (Throwable e) {
            String message = String.format("Failed to calculate source hash for method %s at %s. error: %s", methodNode.getName(), methodNode.getClass(), e);
            AgentLifeCycle.notifyWarningMsg(message);
            return null;
        }
    }

    private List<ArgumentType> extractArgumentTypes(Parameter[] params) {
        ArrayList<ArgumentType> argumentTypes = new ArrayList<ArgumentType>();
        for (Parameter parameter : params) {
            ClassNode originType = parameter.getOriginType();
            String type = originType.isArray() ? originType.getComponentType().toString(false) + "[]" : originType.getText();
            argumentTypes.add(new ArgumentType(type));
        }
        return argumentTypes;
    }

    public String toString() {
        return "SourceMethod{classname='" + this.classname + '\'' + ", name='" + this.name + '\'' + ", argumentTypes=" + this.argumentTypes + ", generatedByCompiler=" + this.generated + '}';
    }

    @Generated
    public String getClassname() {
        return this.classname;
    }

    @Generated
    public String getSourceCode() {
        return this.sourceCode;
    }

    @Generated
    public String getHash() {
        return this.hash;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<ArgumentType> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Generated
    public HashingUtils getHashingUtils() {
        return this.hashingUtils;
    }

    @Generated
    public boolean isGenerated() {
        return this.generated;
    }

    @Generated
    public void setClassname(String classname) {
        this.classname = classname;
    }

    @Generated
    public void setSourceCode(String sourceCode) {
        this.sourceCode = sourceCode;
    }

    @Generated
    public void setHash(String hash) {
        this.hash = hash;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setArgumentTypes(List<ArgumentType> argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    @Generated
    public void setHashingUtils(HashingUtils hashingUtils) {
        this.hashingUtils = hashingUtils;
    }

    @Generated
    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodSourceInfo)) {
            return false;
        }
        MethodSourceInfo other = (MethodSourceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$classname = this.getClassname();
        String other$classname = other.getClassname();
        if (this$classname == null ? other$classname != null : !this$classname.equals(other$classname)) {
            return false;
        }
        String this$sourceCode = this.getSourceCode();
        String other$sourceCode = other.getSourceCode();
        if (this$sourceCode == null ? other$sourceCode != null : !this$sourceCode.equals(other$sourceCode)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<ArgumentType> this$argumentTypes = this.getArgumentTypes();
        List<ArgumentType> other$argumentTypes = other.getArgumentTypes();
        if (this$argumentTypes == null ? other$argumentTypes != null : !((Object)this$argumentTypes).equals(other$argumentTypes)) {
            return false;
        }
        HashingUtils this$hashingUtils = this.getHashingUtils();
        HashingUtils other$hashingUtils = other.getHashingUtils();
        if (this$hashingUtils == null ? other$hashingUtils != null : !this$hashingUtils.equals(other$hashingUtils)) {
            return false;
        }
        return this.isGenerated() == other.isGenerated();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MethodSourceInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $classname = this.getClassname();
        result = result * 59 + ($classname == null ? 43 : $classname.hashCode());
        String $sourceCode = this.getSourceCode();
        result = result * 59 + ($sourceCode == null ? 43 : $sourceCode.hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<ArgumentType> $argumentTypes = this.getArgumentTypes();
        result = result * 59 + ($argumentTypes == null ? 43 : ((Object)$argumentTypes).hashCode());
        HashingUtils $hashingUtils = this.getHashingUtils();
        result = result * 59 + ($hashingUtils == null ? 43 : $hashingUtils.hashCode());
        result = result * 59 + (this.isGenerated() ? 79 : 97);
        return result;
    }
}

