/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.groovy;

import io.sealights.onpremise.agents.buildscanner.groovy.ArgumentType;
import io.sealights.onpremise.agents.buildscanner.groovy.MethodSourceInfo;
import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.objectweb.asm.Type;

public class MethodIdentifier {
    private String classname;
    private String methodName;
    private List<ArgumentType> argumentTypes;

    public MethodIdentifier(MethodSignature methodSignature) {
        this.classname = methodSignature.getClassName();
        this.methodName = methodSignature.getName();
        this.argumentTypes = this.extractArgumentTypes(methodSignature.getDescriptor());
    }

    public MethodIdentifier(MethodSourceInfo methodSourceInfo) {
        this.classname = methodSourceInfo.getClassname();
        this.methodName = methodSourceInfo.getName();
        this.argumentTypes = methodSourceInfo.getArgumentTypes();
    }

    private List<ArgumentType> extractArgumentTypes(String descriptor) {
        Type[] originalArgumentTypes = Type.getArgumentTypes(descriptor);
        ArrayList<ArgumentType> argumentTypes = new ArrayList<ArgumentType>();
        for (Type type : originalArgumentTypes) {
            String className = type.getClassName();
            argumentTypes.add(new ArgumentType(className));
        }
        return argumentTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MethodIdentifier)) {
            return false;
        }
        MethodIdentifier that = (MethodIdentifier)o;
        return Objects.equals(this.classname, that.classname) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.classname, this.methodName);
    }

    public String toString() {
        return "MethodIdentifier{classname='" + this.classname + '\'' + ", methodName='" + this.methodName + '\'' + ", argumentTypes=" + this.argumentTypes + '}';
    }

    @Generated
    public String getClassname() {
        return this.classname;
    }

    @Generated
    public String getMethodName() {
        return this.methodName;
    }

    @Generated
    public List<ArgumentType> getArgumentTypes() {
        return this.argumentTypes;
    }

    @Generated
    public void setClassname(String classname) {
        this.classname = classname;
    }

    @Generated
    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    @Generated
    public void setArgumentTypes(List<ArgumentType> argumentTypes) {
        this.argumentTypes = argumentTypes;
    }

    @ConstructorProperties(value={"classname", "methodName", "argumentTypes"})
    @Generated
    public MethodIdentifier(String classname, String methodName, List<ArgumentType> argumentTypes) {
        this.classname = classname;
        this.methodName = methodName;
        this.argumentTypes = argumentTypes;
    }
}

