/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.groovy;

import groovy.inspect.swingui.AstNodeToScriptVisitor;
import io.sealights.onpremise.agents.commons.instrument.utils.GroovyNamingHelper;
import io.sealights.onpremise.agents.commons.instrument.utils.HashingUtils;
import java.io.StringWriter;
import org.codehaus.groovy.ast.stmt.Statement;

public class GroovyUtils {
    public static final String CLOSURE_LOGICAL_PATH_SUFFIX = "$Closures";

    public static String getSourceCodeHash(Statement code) throws Exception {
        return new HashingUtils().toMD5(GroovyUtils.getSourceCode(code));
    }

    public static String getSourceCode(Statement code) {
        StringWriter stringWriter = new StringWriter();
        AstNodeToScriptVisitor astNodeToScriptVisitor = new AstNodeToScriptVisitor(stringWriter);
        code.visit(astNodeToScriptVisitor);
        return stringWriter.toString().trim();
    }

    public static String normalizeClosureClassName(String closureClassName) {
        if ((closureClassName = closureClassName.replace("/", ".")).endsWith(CLOSURE_LOGICAL_PATH_SUFFIX)) {
            return closureClassName;
        }
        return GroovyUtils.getClosureContainerClass(closureClassName) + CLOSURE_LOGICAL_PATH_SUFFIX;
    }

    public static String getClosureContainerClass(String closureClassName) {
        String[] tokens = closureClassName.split(GroovyNamingHelper.CLASS_DELIMITER);
        return tokens[0];
    }
}

