/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.groovy;

import groovy.lang.Closure;
import groovy.lang.Script;
import io.sealights.onpremise.agents.buildscanner.groovy.ClosureHashUpdater;
import io.sealights.onpremise.agents.buildscanner.groovy.ClosureVisitor;
import io.sealights.onpremise.agents.buildscanner.groovy.GroovyUtils;
import io.sealights.onpremise.agents.buildscanner.groovy.MethodIdentifier;
import io.sealights.onpremise.agents.buildscanner.groovy.MethodSourceInfo;
import io.sealights.onpremise.agents.buildscanner.groovy.TraitMethodIdentifier;
import io.sealights.onpremise.agents.commons.instrument.types.ClassSignature;
import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.builder.AstBuilder;
import org.codehaus.groovy.control.CompilePhase;
import org.slf4j.Logger;

public class GroovyFileHandler {
    private static Logger LOGGER = LogFactory.getLogger(GroovyFileHandler.class);
    public static final String TRAIT_HELPER_SUFFIX = "$Trait$Helper";
    public static final String TRAIT_FIELD_HELPER_SUFFIX = "$Trait$FieldHelper";
    public static final String TRAIT_ANNOTATION = "groovy.transform.Trait";
    public static String GROOVY_FILE_EXT = ".groovy";
    private ClassSignature classSignature;
    private String sourceCode;
    private String className;
    private AstBuilder astBuilder;

    public GroovyFileHandler(ClassSignature classSignature, String sourceCode) {
        this(classSignature, sourceCode, new AstBuilder());
    }

    public GroovyFileHandler(ClassSignature classSignature, String sourceCode, AstBuilder astBuilder) {
        this.classSignature = classSignature;
        this.sourceCode = sourceCode;
        this.astBuilder = astBuilder;
        this.className = classSignature.getClassName().replaceAll("/", ".");
    }

    public void updateFromSource() {
        List<ASTNode> astNodes = this.getAstNodes();
        for (ASTNode node : astNodes) {
            if (!(node instanceof ClassNode)) continue;
            this.updateClassData((ClassNode)node);
        }
    }

    private List<ASTNode> getAstNodes() {
        return this.astBuilder.buildFromString(CompilePhase.CONVERSION, false, this.sourceCode);
    }

    private void updateClassData(ClassNode node) {
        this.normalizeClassName(node);
        boolean isTrait = this.isTrait(node);
        if (this.isClosure()) {
            this.handleClosure(node);
            LOGGER.debug("Class '%s' is closure", (Object)node.getName());
        } else if (this.isClassNamesEquals(node)) {
            this.updateHashes(this.getAllMethodsFromClass(node), isTrait);
        }
    }

    private void handleClosure(ClassNode node) {
        ClosureVisitor closureVisitor = new ClosureVisitor();
        closureVisitor.visitClass(this.getMatchingClass(node));
        ClosureHashUpdater closureHashUpdater = new ClosureHashUpdater(closureVisitor, this.classSignature.getMethods());
        closureHashUpdater.updateHashes();
        String normalizedClassName = GroovyUtils.normalizeClosureClassName(this.classSignature.getClassName());
        this.classSignature.setClassName(normalizedClassName);
    }

    private ClassNode getMatchingClass(ClassNode classNode) {
        Iterator<InnerClassNode> innerClasses = classNode.getInnerClasses();
        while (innerClasses.hasNext()) {
            InnerClassNode innerClassNode = innerClasses.next();
            if (!this.isClassNamesEquals(innerClassNode)) continue;
            return innerClassNode;
        }
        return classNode;
    }

    private void updateHashes(List<MethodNode> methods, boolean isTrait) {
        Map<MethodIdentifier, MethodSourceInfo> methodSourceInfosMap = this.createMethodSourceInfoMap(methods);
        Map<MethodIdentifier, MethodSignature> signatureMethodsMap = this.createSignatureMethodsMap(isTrait);
        for (MethodIdentifier methodIdentifier : signatureMethodsMap.keySet()) {
            MethodSourceInfo methodSourceInfo = methodSourceInfosMap.get(methodIdentifier);
            MethodSignature methodSignature = signatureMethodsMap.get(methodIdentifier);
            if (methodSourceInfo == null || methodSourceInfo.isGenerated() || methodSignature.getStartLineNumber() == null) {
                LOGGER.debug("Method '%s' marked as auto generated, Source method: '%s'", (Object)methodIdentifier, (Object)methodSourceInfo);
                methodSignature.getClassification().setAutoGenerated(true);
                continue;
            }
            if (methodSourceInfo.getHash() == null) {
                LOGGER.debug("Method '%s' source hash is null hash will not update", (Object)methodIdentifier);
                continue;
            }
            methodSignature.setHash(methodSourceInfo.getHash());
            LOGGER.debug("Method '%s' hash updated to '%s'", (Object)methodIdentifier, (Object)methodSourceInfo.getHash());
        }
    }

    private Map<MethodIdentifier, MethodSourceInfo> createMethodSourceInfoMap(List<MethodNode> methods) {
        HashMap<MethodIdentifier, MethodSourceInfo> methodSourceInfosMap = new HashMap<MethodIdentifier, MethodSourceInfo>();
        for (MethodNode method : methods) {
            if (method.getCode() == null) continue;
            MethodSourceInfo methodSourceInfo = new MethodSourceInfo(method);
            MethodIdentifier methodIdentifier = new MethodIdentifier(methodSourceInfo);
            methodSourceInfosMap.put(methodIdentifier, methodSourceInfo);
        }
        return methodSourceInfosMap;
    }

    private Map<MethodIdentifier, MethodSignature> createSignatureMethodsMap(boolean isTrait) {
        List<MethodSignature> signatureMethods = this.classSignature.getMethods();
        HashMap<MethodIdentifier, MethodSignature> signatureMethodsMap = new HashMap<MethodIdentifier, MethodSignature>();
        for (MethodSignature methodSignature : signatureMethods) {
            MethodIdentifier methodIdentifier = isTrait ? new TraitMethodIdentifier(methodSignature) : new MethodIdentifier(methodSignature);
            signatureMethodsMap.put(methodIdentifier, methodSignature);
        }
        return signatureMethodsMap;
    }

    private boolean isScriptFile(ClassNode node) {
        ClassNode superClass = node.getSuperClass();
        if (superClass == null || StringUtils.isNullOrEmpty(superClass.getName())) {
            return false;
        }
        return superClass.getName().equals(Script.class.getName());
    }

    private boolean isClosure() {
        String superName = this.classSignature.getSuperName();
        if (StringUtils.isNotEmpty(superName)) {
            return superName.equals(Closure.class.getName());
        }
        return false;
    }

    private boolean isClassNamesEquals(ClassNode node) {
        return this.className.equals(node.getName());
    }

    private List<MethodNode> getAllMethodsFromClass(ClassNode node) {
        List<MethodNode> methods = node.getMethods();
        List<ConstructorNode> declaredConstructors = node.getDeclaredConstructors();
        methods.addAll(declaredConstructors);
        return methods;
    }

    private void normalizeClassName(ClassNode node) {
        if (this.isScriptFile(node)) {
            this.setClassNameForScript(node);
        } else if (this.isTrait(node)) {
            this.normalizeTraitClassName();
        }
    }

    private boolean isTrait(ClassNode classNode) {
        List<AnnotationNode> annotations = classNode.getAnnotations();
        for (AnnotationNode annotation : annotations) {
            String text = annotation.getClassNode().getText();
            if (!text.equals(TRAIT_ANNOTATION)) continue;
            return true;
        }
        return false;
    }

    private void normalizeTraitClassName() {
        String classSuffix = this.getTraitClassSuffix();
        if (classSuffix != null) {
            int end = this.className.length() - classSuffix.length();
            String shortClassName = this.className.substring(0, end);
            this.classSignature.setClassName(shortClassName);
            this.className = shortClassName;
            for (MethodSignature method : this.classSignature.getMethods()) {
                method.setClassName(shortClassName);
            }
        }
    }

    private void setClassNameForScript(ClassNode node) {
        String fullFileName = this.classSignature.getSourceFile();
        String fileName = fullFileName.substring(0, fullFileName.lastIndexOf(GROOVY_FILE_EXT));
        LOGGER.debug("Class '%s' is a script file class name was set to '%'. (same as source file)", (Object)node.getName(), (Object)fileName);
        node.setName(fileName);
    }

    private String getTraitClassSuffix() {
        if (this.className.endsWith(TRAIT_HELPER_SUFFIX)) {
            return TRAIT_HELPER_SUFFIX;
        }
        if (this.className.endsWith(TRAIT_FIELD_HELPER_SUFFIX)) {
            return TRAIT_FIELD_HELPER_SUFFIX;
        }
        return null;
    }
}

