/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.groovy;

import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.slf4j.Logger;

public class ClosureVisitor
extends ClassCodeVisitorSupport {
    private static Logger LOGGER = LogFactory.getLogger(ClosureVisitor.class);
    private Map<Integer, ClosureExpression> closureExpressions = new HashMap<Integer, ClosureExpression>();

    @Override
    protected void addError(String msg, ASTNode expr) {
        LOGGER.warn("Got error: '%s', for expression: '%s'", (Object)msg, (Object)expr.getText());
    }

    @Override
    protected SourceUnit getSourceUnit() {
        return null;
    }

    @Override
    public void visitClosureExpression(ClosureExpression expression) {
        this.closureExpressions.put(expression.getCode().getLineNumber(), expression);
        expression.getCode().visit(this);
    }

    public ClosureExpression getClosureByLine(Integer line) {
        return this.closureExpressions.get(line);
    }

    @Generated
    public Map<Integer, ClosureExpression> getClosureExpressions() {
        return this.closureExpressions;
    }
}

