/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.groovy;

import io.sealights.onpremise.agents.buildscanner.groovy.ClosureVisitor;
import io.sealights.onpremise.agents.buildscanner.groovy.GroovyUtils;
import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.List;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.slf4j.Logger;

public class ClosureHashUpdater {
    private static final Logger LOGGER = LogFactory.getLogger(ClosureHashUpdater.class);
    private static final String CLOSURE_METHOD_NAME = "doCall";
    private ClosureVisitor closureVisitor;
    private List<MethodSignature> methodSignatures;

    public ClosureHashUpdater(ClosureVisitor closureVisitor, List<MethodSignature> methodSignatures) {
        this.closureVisitor = closureVisitor;
        this.methodSignatures = methodSignatures;
    }

    public void updateHashes() {
        for (MethodSignature methodSignature : this.methodSignatures) {
            Integer startLineNumber = methodSignature.getStartLineNumber();
            ClosureExpression closureByLine = this.closureVisitor.getClosureByLine(startLineNumber);
            if (!this.isDoCall(methodSignature.getName()) || closureByLine == null) {
                this.markMethodAsGenerated(methodSignature);
            } else {
                this.setNewHash(methodSignature, closureByLine);
            }
            methodSignature.getClassification().setGroovyClosure(true);
            methodSignature.getClassification().setAnonymous(true);
        }
    }

    private void setNewHash(MethodSignature methodSignature, ClosureExpression closureByLine) {
        try {
            String sourceCodeHash = GroovyUtils.getSourceCodeHash(closureByLine.getCode());
            methodSignature.setHash(sourceCodeHash);
            LOGGER.debug("Closure at line '%s' in '%s' hash updated to '%s'", methodSignature.getStartLineNumber(), methodSignature.getClassName(), sourceCodeHash);
        }
        catch (Throwable e) {
            String message = String.format("Failed to calculate source hash for closure in line %s at %s. error: %s", closureByLine.getCode().getLineNumber(), methodSignature.getClassName(), e);
            AgentLifeCycle.notifyWarningMsg(message);
        }
    }

    private void markMethodAsGenerated(MethodSignature methodSignature) {
        methodSignature.getClassification().setAutoGenerated(true);
        LOGGER.info("Method '%s' in '%s' has no matching source and marked as auto generated", (Object)(methodSignature.getName() + methodSignature.getDescriptor()), (Object)methodSignature.getClassName());
    }

    private boolean isDoCall(String methodName) {
        return methodName.equals(CLOSURE_METHOD_NAME);
    }
}

