/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.groovy;

import java.util.Objects;
import lombok.Generated;

public class ArgumentType {
    private static final String DOT = ".";
    private String fullClassName;
    private String shortClassName;

    public ArgumentType(String classname) {
        this.fullClassName = classname;
        this.shortClassName = this.resolveShortClassname(classname);
    }

    public boolean isFullDifferentThanShort() {
        return !this.fullClassName.equals(this.shortClassName);
    }

    private String resolveShortClassname(String classname) {
        int indexOfDot = classname.lastIndexOf(DOT);
        if (indexOfDot > -1) {
            return classname.substring(indexOfDot + 1);
        }
        return classname;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArgumentType)) {
            return false;
        }
        ArgumentType that = (ArgumentType)o;
        if (this.isFullDifferentThanShort() && that.isFullDifferentThanShort()) {
            return Objects.equals(this.fullClassName, that.getFullClassName());
        }
        return Objects.equals(this.shortClassName, that.getShortClassName());
    }

    public int hashCode() {
        return Objects.hash(this.fullClassName, this.shortClassName);
    }

    @Generated
    public String getFullClassName() {
        return this.fullClassName;
    }

    @Generated
    public String getShortClassName() {
        return this.shortClassName;
    }
}

