/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration;

import io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration.ScanConfigurationInfo;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.infra.git.configuration.GitWorkConfiguration;
import io.sealights.onpremise.agents.infra.git.configuration.GitWorkConfigurationFactory;
import io.sealights.onpremise.agents.infra.git.configuration.ScmSettings;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class ScmInputHandler {
    private ScanModeArguments scanArgs;
    private ScanConfigurationInfo configurationInfo;

    public GitWorkConfiguration createGitWorkConfiguration() {
        String gitProviderInput = this.resolveGitProviderInput();
        String gitProviderVersion = this.resolveGitProviderVersion();
        String scmTypeInput = this.resolveScmTypeInput();
        String baseUrlInput = this.resolveBaseUrl();
        return GitWorkConfigurationFactory.createConfiguration(this.configurationInfo, this.scanArgs.getWorkspacePath(), new ScmSettings(gitProviderInput, gitProviderVersion, baseUrlInput, scmTypeInput));
    }

    private String resolveScmTypeInput() {
        String scm = null;
        if (StringUtils.isNotEmpty(this.scanArgs.getScm())) {
            scm = this.scanArgs.getScm();
        } else if (StringUtils.isNotEmpty(this.configurationInfo.getScmSettings().getType())) {
            scm = this.configurationInfo.getScmSettings().getType();
        }
        return scm;
    }

    private String resolveGitProviderInput() {
        String provider = null;
        if (StringUtils.isNotEmpty(this.scanArgs.getScmProvider())) {
            provider = this.scanArgs.getScmProvider();
        } else if (!StringUtils.isNullOrEmpty(this.configurationInfo.getScmSettings().getGitProvider())) {
            provider = this.configurationInfo.getScmSettings().getGitProvider();
        }
        return provider;
    }

    private String resolveGitProviderVersion() {
        if (StringUtils.isNotEmpty(this.scanArgs.getScmVersion())) {
            return this.scanArgs.getScmVersion();
        }
        if (StringUtils.isNotEmpty(this.configurationInfo.getScmSettings().getVersion())) {
            return this.configurationInfo.getScmSettings().getVersion();
        }
        return null;
    }

    private String resolveBaseUrl() {
        if (StringUtils.isNotEmpty(this.scanArgs.getScmBaseUrl())) {
            return this.scanArgs.getScmBaseUrl();
        }
        if (StringUtils.isNotEmpty(this.configurationInfo.getScmSettings().getBaseUrl())) {
            return this.configurationInfo.getScmSettings().getBaseUrl();
        }
        return null;
    }

    @Generated
    public ScanModeArguments getScanArgs() {
        return this.scanArgs;
    }

    @Generated
    public ScanConfigurationInfo getConfigurationInfo() {
        return this.configurationInfo;
    }

    @Generated
    public void setScanArgs(ScanModeArguments scanArgs) {
        this.scanArgs = scanArgs;
    }

    @Generated
    public void setConfigurationInfo(ScanConfigurationInfo configurationInfo) {
        this.configurationInfo = configurationInfo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScmInputHandler)) {
            return false;
        }
        ScmInputHandler other = (ScmInputHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScanModeArguments this$scanArgs = this.getScanArgs();
        ScanModeArguments other$scanArgs = other.getScanArgs();
        if (this$scanArgs == null ? other$scanArgs != null : !((Object)this$scanArgs).equals(other$scanArgs)) {
            return false;
        }
        ScanConfigurationInfo this$configurationInfo = this.getConfigurationInfo();
        ScanConfigurationInfo other$configurationInfo = other.getConfigurationInfo();
        return !(this$configurationInfo == null ? other$configurationInfo != null : !((Object)this$configurationInfo).equals(other$configurationInfo));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScmInputHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScanModeArguments $scanArgs = this.getScanArgs();
        result = result * 59 + ($scanArgs == null ? 43 : ((Object)$scanArgs).hashCode());
        ScanConfigurationInfo $configurationInfo = this.getConfigurationInfo();
        result = result * 59 + ($configurationInfo == null ? 43 : ((Object)$configurationInfo).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ScmInputHandler(scanArgs=" + this.getScanArgs() + ", configurationInfo=" + this.getConfigurationInfo() + ")";
    }

    @ConstructorProperties(value={"scanArgs", "configurationInfo"})
    @Generated
    public ScmInputHandler(ScanModeArguments scanArgs, ScanConfigurationInfo configurationInfo) {
        this.scanArgs = scanArgs;
        this.configurationInfo = configurationInfo;
    }
}

