/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration;

import io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration.ScanConfigurationInfo;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.commons.configuration.ConfigurationPrinter;
import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.env.DefaultDirs;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.token.TokenData;
import io.sealights.onpremise.agents.infra.token.TokenError;
import io.sealights.onpremise.agents.infra.token.TokenParser;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import lombok.Generated;
import org.slf4j.Logger;

public class ScanConfigurationManager {
    private static Logger LOG = LogFactory.getLogger(ScanConfigurationManager.class);
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private ScanConfigurationInfo configurationInfo;
    private String configFileName;
    private ScanModeArguments arguments;
    private static final String DEFAULT_CONFIG_FILE_NAME = "sealights.properties";

    public ScanConfigurationManager(ScanModeArguments arguments) {
        this(DEFAULT_CONFIG_FILE_NAME, arguments);
    }

    public ScanConfigurationManager(String configFileName, ScanModeArguments arguments) {
        String slConfigFile = System.getProperty("sl.config.file");
        this.configFileName = slConfigFile != null && !"".equals(slConfigFile) ? slConfigFile : configFileName;
        this.arguments = arguments;
    }

    public ScanConfigurationInfo getOrLoadConfiguration() {
        boolean isConfigurationLoaded;
        boolean bl = isConfigurationLoaded = this.configurationInfo != null;
        if (!isConfigurationLoaded) {
            this.configurationInfo = new ScanConfigurationInfo();
            this.tryLoadConfigurationFromFile();
            this.tryLoadConfigurationFromArguments();
            this.tryLoadConfigurationFromSystemProperties();
            String token = this.getToken(this.configurationInfo);
            this.tryUseToken(token);
            this.printConfiguration("Current");
            if (!this.isConfigurationValid()) {
                return null;
            }
        }
        return this.configurationInfo;
    }

    private String getToken(ScanConfigurationInfo configInfo) {
        if (!StringUtils.isNullOrEmpty(configInfo.getToken())) {
            return configInfo.getToken();
        }
        String customerId = configInfo.getCustomerId();
        if (!StringUtils.isNullOrEmpty(customerId) && customerId.startsWith("eyJhbGciOiJSUzUxMiIsInR5cCI6IkpXVCJ9.")) {
            configInfo.setToken(customerId);
        }
        return configInfo.getToken();
    }

    protected void tryLoadConfigurationFromSystemProperties() {
        Boolean compressRequests = SystemPropertiesHelper.getBoolObjectProperty("sl.featuresData.compressRequests");
        if (compressRequests != null) {
            this.configurationInfo.setCompressRequest(compressRequests);
        }
        this.configurationInfo.getScmSettings().setGitProvider(System.getProperty("sl.scm.provider"));
        this.configurationInfo.getScmSettings().setVersion(System.getProperty("sl.scm.version"));
        this.configurationInfo.getScmSettings().setBaseUrl(System.getProperty("sl.scm.baseUrl"));
        this.configurationInfo.getScmSettings().setType(System.getProperty("sl.scm"));
        this.configurationInfo.setLineCoverageEnabled("true".equalsIgnoreCase(System.getProperty("sl.featuresData.enableLineCoverage")));
        this.configurationInfo.setIgnoreMethodsWithoutLineNumbers("true".equalsIgnoreCase(System.getProperty("sl.featuresData.ignoreMethodsWithoutLineNumbers")));
        this.configurationInfo.setIgnoreAutoGeneratedCode("true".equalsIgnoreCase(System.getProperty("sl.featuresData.ignoreAutoGeneratedMethods")));
        this.configurationInfo.setReportOnConstructors(!"false".equalsIgnoreCase(System.getProperty("sl.featuresData.reportOnConstructors")));
        this.configurationInfo.setReportOnGettersAndSetters(!"false".equalsIgnoreCase(System.getProperty("sl.featuresData.reportOnGettersAndSetters")));
        this.configurationInfo.setCustomFilterFile(System.getProperty("sl.customFilterFile"));
        this.configurationInfo.setClassAnnotationsExcluded(System.getProperty("sl.featuresData.classAnnotationsExcluded"));
        this.configurationInfo.setMethodAnnotationsExcluded(System.getProperty("sl.featuresData.methodAnnotationsExcluded"));
    }

    private void tryUseToken(String tokenValue) {
        try {
            if (StringUtils.isNullOrEmpty(tokenValue)) {
                LOG.debug("Token wasn't set. Ignoring it.");
                return;
            }
            TokenData tokenData = TokenParser.parseAndValidate(tokenValue);
            List<TokenError> tokenErrors = tokenData.getValidationErrors();
            if (tokenErrors.size() > 0) {
                LOG.error("Invalid token. The token contain the following errors:");
                for (TokenError err : tokenErrors) {
                    LOG.error(err.toString());
                }
                return;
            }
            this.configurationInfo.setCustomerId(tokenData.getCustomerId());
            if (StringUtils.isNullOrEmpty(this.configurationInfo.getServer())) {
                this.configurationInfo.setServer(tokenData.getServer());
            }
        }
        catch (Exception e) {
            LOG.error("Failed to use the specified token. Error:", e);
        }
    }

    private void tryLoadConfigurationFromArguments() {
        if (this.arguments == null) {
            return;
        }
        if (!StringUtils.isNullOrEmpty(this.arguments.getCustomerId())) {
            this.configurationInfo.setCustomerId(this.arguments.getCustomerId());
        }
        if (!StringUtils.isNullOrEmpty(this.arguments.getToken())) {
            this.configurationInfo.setToken(this.arguments.getToken());
        }
        if (!StringUtils.isNullOrEmpty(this.arguments.getServer())) {
            this.configurationInfo.setServer(this.arguments.getServer());
        }
        if (!StringUtils.isNullOrEmpty(this.arguments.getProxy())) {
            this.configurationInfo.setProxy(this.arguments.getProxy());
        }
        if (!StringUtils.isNullOrEmpty(this.arguments.getAppname())) {
            this.configurationInfo.setAppName(this.arguments.getAppname());
        }
        if (!StringUtils.isNullOrEmpty(this.arguments.getBranch())) {
            this.configurationInfo.setBranchName(this.arguments.getBranch());
        }
        if (!StringUtils.isNullOrEmpty(this.arguments.getBuild())) {
            this.configurationInfo.setBuildName(this.arguments.getBuild());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryLoadConfigurationFromFile() {
        LOG.info("Try to load configuration from file '{}', directory '{}'", (Object)this.configFileName, (Object)DefaultDirs.WORKING_DIR);
        Properties propertiesFile = new Properties();
        InputStream input = this.createConfigurationInputStream();
        if (input != null) {
            try {
                propertiesFile.load(input);
                this.configurationInfo.setCustomerId(propertiesFile.getProperty("customerid"));
                this.configurationInfo.setServer(propertiesFile.getProperty("server"));
                this.configurationInfo.setProxy(propertiesFile.getProperty("proxy"));
            }
            catch (Exception e) {
                LOG.info("Error while loading configuration file: {}", (Object)e.getMessage());
            }
            finally {
                this.closeStream(input);
            }
        }
    }

    private void closeStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.error("Error when trying to close configuration file stream. Error: {}", (Object)e.getMessage());
            }
        }
    }

    private InputStream createConfigurationInputStream() {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(this.configFileName);
        }
        catch (FileNotFoundException e) {
            LOG.info(String.format("Configuration file not found in path '%s', error: %s", DefaultDirs.WORKING_DIR, e.getMessage()));
        }
        return inputStream;
    }

    private boolean isConfigurationValid() {
        boolean isValid = true;
        if (StringUtils.isNullOrEmpty(this.configurationInfo.getCustomerId())) {
            CONSOLE_LOG.println("Error. Invalid configuration: 'customerid' is null or empty string. Please specify it using the command line arguments or via configuration file.");
            LOG.error("ConfigurationManager.isConfigurationValid - 'customerid' is null or empty string. This means that the agent will NOT report any information at all.");
            isValid = false;
        }
        if (StringUtils.isNullOrEmpty(this.configurationInfo.getServer())) {
            CONSOLE_LOG.println("Error. Invalid configuration: 'server' is null or empty string. Please specify it using the command line arguments or via configuration file.");
            LOG.error("ConfigurationManager.isConfigurationValid - 'server' is null or empty string. This means that the agent will NOT report any information at all.");
            isValid = false;
        }
        return isValid;
    }

    private void printConfiguration(String configurationDecsriptor) {
        ConfigurationPrinter.printConfiguration(this.configurationInfo, configurationDecsriptor);
    }

    @Generated
    public ScanConfigurationInfo getConfigurationInfo() {
        return this.configurationInfo;
    }
}

