/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration;

import io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration.ScanConfigurationInfo;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanArgsValidator;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.commons.defaultfiles.DefaultFileResolver;
import io.sealights.onpremise.agents.infra.configuration.SLBaseSettings;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionServiceProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionServiceProxyHandler;
import io.sealights.onpremise.agents.infra.types.AdditionalArgumentsData;
import io.sealights.onpremise.agents.infra.types.BuildSessionData;
import io.sealights.onpremise.agents.infra.utils.ArgumentFileReader;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import lombok.Generated;
import org.slf4j.Logger;

public class SLScanSettings
extends SLBaseSettings {
    private static Logger LOG = LogFactory.getLogger(SLScanSettings.class);
    private final ScanArgsValidator scanArgsValidator = new ScanArgsValidator();
    private ScanModeArguments scanArgs;
    private ScanConfigurationInfo configurationInfo;
    private BuildSessionServiceProxy buildSessionIdProxy;

    public SLScanSettings(ScanModeArguments scanArgs, ScanConfigurationInfo configurationInfo) {
        this.scanArgs = scanArgs;
        this.configurationInfo = configurationInfo;
    }

    public boolean execute() {
        this.initTokenAndBuildSessionId();
        this.initCustomFilterFile();
        this.initBuildSessionIdProxy();
        return this.isValid();
    }

    protected boolean isValid() {
        if (this.configurationInfo == null) {
            return false;
        }
        if (StringUtils.isNullOrEmpty(this.scanArgs.getBuildSessionId())) {
            ValidationResult validationResult = this.scanArgsValidator.validate(this.scanArgs);
            this.logProblems(validationResult);
            return validationResult.isValid();
        }
        return this.updateArgumentsByBuildSessionId();
    }

    protected void initTokenAndBuildSessionId() {
        if (StringUtils.isNullOrEmpty(this.scanArgs.getBuildSessionIdFile()) && StringUtils.isNullOrEmpty(this.scanArgs.getBuildSessionId())) {
            LOG.info("Auto-detected buildSessionIdFile");
            this.scanArgs.setBuildSessionIdFile(DefaultFileResolver.resolveBldSessionId());
        }
        this.scanArgs.setToken(ArgumentFileReader.resolve(this.scanArgs.getToken(), this.scanArgs.getTokenFile()));
        this.scanArgs.setBuildSessionId(ArgumentFileReader.resolve(this.scanArgs.getBuildSessionId(), this.scanArgs.getBuildSessionIdFile()));
        this.configurationInfo.setToken(this.scanArgs.getToken());
        this.configurationInfo.setBuildSessionId(this.scanArgs.getBuildSessionId());
    }

    private void initCustomFilterFile() {
        String argValue = this.scanArgs.getCustomFilterFile();
        String configValue = this.configurationInfo.getCustomFilterFile();
        if (StringUtils.isNotEmpty(argValue)) {
            this.configurationInfo.setCustomFilterFile(argValue);
            if (StringUtils.isNotEmpty(configValue)) {
                LOG.info("The 'customFilterFile' CLI argument '{}' overrides provided '-D{}={}'", argValue, "sl.customFilterFile", configValue);
            }
        }
    }

    private void initBuildSessionIdProxy() {
        if (this.buildSessionIdProxy == null) {
            this.buildSessionIdProxy = new BuildSessionServiceProxyHandler(this.scanArgs.getToken(), this.configurationInfo.getServer(), this.configurationInfo.getProxy());
        }
    }

    protected boolean updateArgumentsByBuildSessionId() {
        BuildSessionData buildSessionData = this.getBuildSessionData();
        if (buildSessionData == null) {
            return false;
        }
        this.setArgumentsBySessionId(buildSessionData);
        return true;
    }

    private void logProblems(ValidationResult argumentsValidationResult) {
        boolean valid = argumentsValidationResult.isValid();
        if (!valid) {
            CONSOLE_LOG.error("Invalid configuration:");
            argumentsValidationResult.logErrors(CONSOLE_LOG);
        }
    }

    protected BuildSessionData getBuildSessionData() {
        String buildSessionId = this.scanArgs.getBuildSessionId();
        return this.buildSessionIdProxy.getBuildSessionData(buildSessionId);
    }

    private void setArgumentsBySessionId(BuildSessionData buildSessionData) {
        boolean isDefaultPackagesExcluded;
        boolean useBuildSessionPackagesExcluded;
        boolean useBuildSessionPackagesIncluded;
        if (StringUtils.isNullOrEmpty(this.scanArgs.getAppname())) {
            this.scanArgs.setAppname(buildSessionData.getAppName());
            this.configurationInfo.setAppName(buildSessionData.getAppName());
        }
        if (StringUtils.isNullOrEmpty(this.scanArgs.getBuild())) {
            this.scanArgs.setBuild(buildSessionData.getBuildName());
            this.configurationInfo.setBuildName(buildSessionData.getBuildName());
        }
        if (StringUtils.isNullOrEmpty(this.scanArgs.getBranch())) {
            this.scanArgs.setBranch(buildSessionData.getBranchName());
            this.configurationInfo.setBranchName(buildSessionData.getBranchName());
        }
        AdditionalArgumentsData additionalParams = buildSessionData.getAdditionalParams();
        String packagesIncluded = this.scanArgs.getPackagesIncluded();
        boolean bl = useBuildSessionPackagesIncluded = StringUtils.isNullOrEmpty(packagesIncluded) && !StringUtils.isNullOrEmpty(additionalParams.getPackagesIncluded());
        if (useBuildSessionPackagesIncluded) {
            this.scanArgs.setPackagesIncluded(additionalParams.getPackagesIncluded());
        }
        boolean bl2 = useBuildSessionPackagesExcluded = (isDefaultPackagesExcluded = "*FastClassByGuice*, *ByCGLIB*, *WithCGLIB*, *EnhancerBySpringCGLIB*, *FastClassBySpringCGLIB*, *MockitoMock*".equals(this.scanArgs.getPackagesExcluded())) && !StringUtils.isNullOrEmpty(additionalParams.getPackagesExcluded());
        if (useBuildSessionPackagesExcluded) {
            this.scanArgs.setPackagesExcluded(additionalParams.getPackagesExcluded());
        }
    }

    @Generated
    public void setScanArgs(ScanModeArguments scanArgs) {
        this.scanArgs = scanArgs;
    }

    @Generated
    public ScanModeArguments getScanArgs() {
        return this.scanArgs;
    }

    @Generated
    public void setConfigurationInfo(ScanConfigurationInfo configurationInfo) {
        this.configurationInfo = configurationInfo;
    }

    @Generated
    public ScanConfigurationInfo getConfigurationInfo() {
        return this.configurationInfo;
    }

    @Generated
    public void setBuildSessionIdProxy(BuildSessionServiceProxy buildSessionIdProxy) {
        this.buildSessionIdProxy = buildSessionIdProxy;
    }

    @Generated
    public BuildSessionServiceProxy getBuildSessionIdProxy() {
        return this.buildSessionIdProxy;
    }
}

