/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.scan;

import io.sealights.onpremise.agents.buildscanner.execmode.scan.ModulesScanner;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.ScanModeExecutor;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.token.TokenData;
import io.sealights.onpremise.agents.infra.utils.ToStringFormatter;
import java.util.Collection;
import org.slf4j.Logger;

public class ScanModulesModeExecutor
extends ScanModeExecutor {
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static Logger LOG = LogFactory.getLogger(ScanModulesModeExecutor.class);

    public ScanModulesModeExecutor(ScanModeArguments arguments) {
        super(arguments);
    }

    @Override
    public void printTokenErrors(TokenData tokenData) {
    }

    @Override
    protected boolean isValidConfiguration() {
        return true;
    }

    @Override
    protected boolean scanFiles() {
        LOG.info("Start scanning for available packages");
        ModulesScanner scanner = new ModulesScanner((ScanModeArguments)this.getArguments());
        Collection packages = (Collection)scanner.scan();
        if (packages.isEmpty()) {
            LOG.info("No relevant files for available packages scanning");
        } else {
            LOG.info("Collected packages (size={}):\n{}", (Object)packages.size(), (Object)ToStringFormatter.toString(packages));
            this.printModules(packages);
        }
        return true;
    }

    @Override
    public boolean isTokenRelevant() {
        return false;
    }

    private void printModules(Collection<String> modules) {
        StringBuilder buf = new StringBuilder();
        int ctr = 0;
        int lastCtr = modules.size() - 1;
        for (String element : modules) {
            buf.append(element);
            if (ctr++ >= lastCtr) continue;
            buf.append(",");
        }
        CONSOLE_LOG.info("available modules :\n{}\n{}", (Object)buf.toString(), (Object)ToStringFormatter.toString(modules));
    }
}

