/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.scan;

import io.sealights.onpremise.agentevents.eventservice.proxy.api.EndBuildEventRequest;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.BuildMappingServiceProxyHandler;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.BuildScanData;
import io.sealights.onpremise.agents.buildscanner.execmode.ModeExecutor;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.AgentDescriptorByScanArgsCreator;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.FilesScanner;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration.SLScanSettings;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration.ScanConfigurationInfo;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration.ScanConfigurationManager;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration.ScmInputHandler;
import io.sealights.onpremise.agents.buildscanner.integbuild.component.ComponentsInputHandler;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.buildscanner.scm.utils.ToStringFormatter;
import io.sealights.onpremise.agents.commons.configuration.ConfigurationListener;
import io.sealights.onpremise.agents.commons.configuration.RemoteConfigurationHandler;
import io.sealights.onpremise.agents.commons.instrument.utils.MethodHashingStringNotifier;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.git.controller.GitController;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import lombok.Generated;
import org.slf4j.Logger;

public class ScanModeExecutor
extends ModeExecutor<ScanModeArguments>
implements ConfigurationListener<ScanConfigurationInfo> {
    private static final String FAILURE = "Failure.";
    private static Logger LOG = LogFactory.getLogger(ScanModeExecutor.class);
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static final String INVALID_CONFIG_CANNOT_SCAN = "Cannot scan files due to invalid configuration";
    private static final String INVALID_DEPS_INPUT_CANNOT_SCAN = "Cannot scan integration build due to invalid depencdencies input, ";
    @Deprecated
    public static final String REPORT_EMPTY_MODULE_PROPERTY = "sl.reportEmptyModule";
    private ScanConfigurationInfo configurationInfo;
    private GitController gitController;

    public ScanModeExecutor(ScanModeArguments arguments) {
        super(arguments);
    }

    @Override
    public boolean execute() {
        this.normalizePathArgs();
        if (!this.isValidConfiguration()) {
            this.notifyStartError(INVALID_CONFIG_CANNOT_SCAN);
            CONSOLE_LOG.status(FAILURE);
            return false;
        }
        AgentLifeCycle.initEventController(new AgentDescriptorByScanArgsCreator((ScanModeArguments)this.getArguments(), true), this.configurationInfo);
        this.tryToApplyRemoteConfiguration();
        ComponentsInputHandler componentsInputHandler = new ComponentsInputHandler(((ScanModeArguments)this.getArguments()).getComponentArguments(), false);
        ValidationResult componentsValidationResult = componentsInputHandler.processAndValidate();
        if (!componentsValidationResult.isValid()) {
            return this.handleInvalidResult(componentsValidationResult, INVALID_DEPS_INPUT_CANNOT_SCAN);
        }
        ((ScanModeArguments)this.getArguments()).setIntegBuildDependencies(componentsInputHandler.getComponents());
        AgentLifeCycle.notifyStart(true);
        this.collectGitData();
        return this.scanFiles();
    }

    private void collectGitData() {
        this.gitController = GitController.createInstance(new ScmInputHandler((ScanModeArguments)this.getArguments(), this.configurationInfo).createGitWorkConfiguration(), AgentLifeCycle.INSTANCE.getEventsController());
        this.gitController.collectGitData();
    }

    private boolean handleInvalidResult(ValidationResult invalidResult, String errorMsg) {
        String error = errorMsg + invalidResult.toStringErrors();
        CONSOLE_LOG.error(error);
        this.notifyStartError(error);
        return false;
    }

    public void notifyUnexpectedError(Exception e) {
        AgentLifeCycle.notifyException(ScanModeExecutor.class, "Unexpected error on scanning", e);
    }

    private void notifyStartError(String error) {
        AgentLifeCycle.notifyStartError(new AgentDescriptorByScanArgsCreator((ScanModeArguments)this.getArguments()), this.configurationInfo, error);
    }

    private void normalizePathArgs() {
        ((ScanModeArguments)this.getArguments()).setWorkspacePath(this.normalizePathArg(((ScanModeArguments)this.getArguments()).getWorkspacePath(), "workspacepath"));
        if (StringUtils.isNotEmpty(((ScanModeArguments)this.getArguments()).getSourcePath())) {
            ((ScanModeArguments)this.getArguments()).setSourcePath(this.normalizePathArg(((ScanModeArguments)this.getArguments()).getSourcePath(), "sourcePath"));
        }
    }

    protected boolean isValidConfiguration() {
        this.configurationInfo = this.loadConfiguration();
        return new SLScanSettings((ScanModeArguments)this.getArguments(), this.configurationInfo).execute();
    }

    protected boolean scanFiles() {
        LOG.debug("Start scanning classes signatures ...");
        BuildScanData buildScanData = null;
        if (!this.isScanDemanded()) {
            buildScanData = new BuildScanData();
        } else {
            FilesScanner scanner = new FilesScanner((ScanModeArguments)this.getArguments(), this.configurationInfo);
            buildScanData = scanner.scan();
            if (!buildScanData.isEmpty()) {
                LOG.info("Scanned classes signatures(size={}) in sources directory '{}':\n{}", buildScanData.getSourcesDirectory(), buildScanData.getClassSignatures().size(), ToStringFormatter.toStringCompact(buildScanData.getClassSignatures()));
            }
        }
        boolean scanResult = this.sendBuildMappingToServer(this.configurationInfo, buildScanData);
        this.reportEndOfBuildForEmptyModule(scanResult);
        return scanResult;
    }

    protected boolean sendBuildMappingToServer(ScanConfigurationInfo configurationInfo, BuildScanData buildScanData) {
        BuildMappingServiceProxyHandler buildMappingProxy = new BuildMappingServiceProxyHandler((ScanModeArguments)this.getArguments(), configurationInfo, this.gitController);
        return buildMappingProxy.sendBuildScanData(buildScanData);
    }

    protected String normalizePathArg(String pathArg, String argName) {
        String absolutePathArg = FileAndFolderUtils.resolveAbsolutePath(pathArg);
        if (!FileAndFolderUtils.isFolderExists(absolutePathArg)) {
            CONSOLE_LOG.info("Invalid '{}' '{}' was provided: directory '{}' does not exist; build files scanning cannot be done", argName, pathArg, absolutePathArg);
            return null;
        }
        if (pathArg.equals(absolutePathArg)) {
            LOG.info("Using the original '{}':'{}'", (Object)argName, (Object)pathArg);
            return pathArg;
        }
        LOG.info("The relative '{}':'{}' was replaced by the absolute path:'{}'", argName, pathArg, absolutePathArg);
        return absolutePathArg;
    }

    protected ScanConfigurationInfo loadConfiguration() {
        if (!this.getTokenData().isValid() && StringUtils.isNullOrEmpty(((ScanModeArguments)this.getArguments()).getCustomerId())) {
            CONSOLE_LOG.println("Invalid configuration. Missing 'token' or 'tokenFile'. Please use one of them. If you are missing this information, please contact support@sealights.io");
            return null;
        }
        ScanConfigurationManager confManager = new ScanConfigurationManager((ScanModeArguments)this.getArguments());
        return confManager.getOrLoadConfiguration();
    }

    protected void tryToApplyRemoteConfiguration() {
        RemoteConfigurationHandler<ScanConfigurationInfo> configurationHandler = new RemoteConfigurationHandler<ScanConfigurationInfo>(this.configurationInfo);
        configurationHandler.addListener(this);
        configurationHandler.execute();
    }

    protected void reportEndOfBuildForEmptyModule(boolean scanResult) {
        if (StringUtils.isNullOrEmpty(((ScanModeArguments)this.getArguments()).getModuleName())) {
            LOG.info("Module name is empty, sending end-of-build ...");
            AgentLifeCycle.notifyBuildEnd(new EndBuildEventRequest(this.getTokenData().getCustomerId(), ((ScanModeArguments)this.getArguments()).getAppname(), ((ScanModeArguments)this.getArguments()).getBuild(), ((ScanModeArguments)this.getArguments()).getBranch(), new EndBuildEventRequest.EventStatus(scanResult, 0L, null)));
        }
    }

    private boolean isScanDemanded() {
        if (this.isReportEmptyModulePropertyTrue() || this.isIntegrativeBuild()) {
            String msg = "Empty module or integrative build - scanning will not be done";
            CONSOLE_LOG.println(msg);
            LOG.warn(msg);
            return false;
        }
        return true;
    }

    @Deprecated
    private boolean isReportEmptyModulePropertyTrue() {
        return SystemPropertiesHelper.getBoolProperty(REPORT_EMPTY_MODULE_PROPERTY);
    }

    private boolean isIntegrativeBuild() {
        return ((ScanModeArguments)this.getArguments()).getComponentArguments().hasFileInput() || ((ScanModeArguments)this.getArguments()).getComponentArguments().hasValuesInput();
    }

    @Override
    public void onConfigurationChanged(ScanConfigurationInfo configuration) {
        MethodHashingStringNotifier.onConfigurationChanged();
    }

    @Generated
    public ScanConfigurationInfo getConfigurationInfo() {
        return this.configurationInfo;
    }
}

