/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.scan;

import io.sealights.onpremise.agents.buildscanner.execmode.IncludeExcludeFilterFactory;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.ClassFilesScanner;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.commons.instrument.types.ClassSignature;
import io.sealights.onpremise.agents.commons.instrument.utils.ClassSignatureFactory;
import io.sealights.onpremise.agents.infra.filters.IncludeExcludeFilter;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.io.InputStream;
import java.util.Collection;
import java.util.TreeSet;
import org.slf4j.Logger;

public class ModulesScanner
extends ClassFilesScanner<Collection<String>> {
    private static Logger LOG = LogFactory.getLogger(ModulesScanner.class);
    private IncludeExcludeFilter embedJarsFilter = new IncludeExcludeFilter(null, "*.lib.*");
    private Collection<String> packages = new TreeSet<String>();
    private boolean isJarArchive = false;
    private int modulePathLength;

    public ModulesScanner(ScanModeArguments scanArguments) {
        super(scanArguments);
        this.modulePathLength = scanArguments.getModulePathLength();
    }

    @Override
    protected IncludeExcludeFilter createPackagesFilter() {
        return IncludeExcludeFilterFactory.createDependenciesFilter();
    }

    @Override
    protected void handleArchive(String archivePath) {
        this.isJarArchive = archivePath.toLowerCase().endsWith(".jar");
        super.handleArchive(archivePath);
    }

    @Override
    protected boolean isEmbeddedJarRelevant(String jarName) {
        if (this.isJarArchive || !this.embedJarsFilter.filter(jarName)) {
            LOG.debug("Embedded jar '{}' was skiped", (Object)jarName);
            return false;
        }
        return true;
    }

    @Override
    public Collection<String> getScannedData() {
        return this.packages;
    }

    @Override
    protected ClassSignature createClassSignature(InputStream classStream) {
        return ClassSignatureFactory.createDefaultScanSignature(classStream);
    }

    @Override
    void appendClassSignature(ClassSignature classSignature) {
        this.packages.add(ModulesScanner.mostSignificantPath(ModulesScanner.asPackage(classSignature.getClassPackage()), this.modulePathLength));
    }

    @Override
    boolean skipAutogenerated() {
        return false;
    }

    @Override
    boolean skipByClassAnnotationsExcluded(ClassSignature classSignature) {
        return false;
    }

    public static String mostSignificantPath(String packageName, int pathLength) {
        String WILD_CHAR = "*";
        String DOT = ".";
        String[] pathSplit = packageName.split("\\.");
        if (pathSplit.length > pathLength) {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < pathLength; ++i) {
                buf.append(pathSplit[i]).append(".");
            }
            buf.append("*");
            return buf.toString();
        }
        return packageName + "*";
    }
}

