/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.scan;

import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import lombok.Generated;

public enum GroovyHandlingMonitor {
    INSTANCE;

    public static final String GROOVY_SOURCE_LANGUAGE = "Detected Groovy usage";
    public static final String ALL_SOURCES_DIDNT_MATCH = "Can't find the sources for any groovy file";
    public static final String SOURCE_FOLDER_NOT_EXISTS = "Source folder '%s' not exists";
    public static final String SOURCE_FOLDER_CANT_READ = "Source folder '%s' is unreadable";
    private boolean isGroovyDetected = false;
    private boolean sourcesMatch = false;
    private String errorMessage = null;

    public void notifyGroovyDetected() {
        if (!this.isGroovyDetected) {
            AgentLifeCycle.notifyInfoMsg(GROOVY_SOURCE_LANGUAGE);
            this.isGroovyDetected = true;
        }
    }

    public void notifySourcesStatus() {
        this.checkSourceCodeMatch();
        if (this.errorMessage != null) {
            AgentLifeCycle.notifyWarningMsg(this.errorMessage);
        }
    }

    private void checkSourceCodeMatch() {
        if (!this.isGroovyDetected) {
            return;
        }
        if (!this.sourcesMatch && this.errorMessage == null) {
            this.errorMessage = ALL_SOURCES_DIDNT_MATCH;
        }
    }

    public void setCannotReadError(String sourceDir) {
        this.errorMessage = String.format(SOURCE_FOLDER_CANT_READ, sourceDir);
    }

    public void setFolderNotExistsError(String sourceDir) {
        this.errorMessage = String.format(SOURCE_FOLDER_NOT_EXISTS, sourceDir);
    }

    public void initState() {
        this.isGroovyDetected = false;
        this.sourcesMatch = false;
        this.errorMessage = null;
    }

    @Generated
    public boolean isSourcesMatch() {
        return this.sourcesMatch;
    }

    @Generated
    public void setSourcesMatch(boolean sourcesMatch) {
        this.sourcesMatch = sourcesMatch;
    }
}

