/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.scan;

import io.sealights.onpremise.agentevents.engine.AgentEventsController;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.BuildScanData;
import io.sealights.onpremise.agents.buildscanner.execmode.IncludeExcludeFilterFactory;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.ClassFilesScanner;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.GroovyHandlingMonitor;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration.ScanConfigurationInfo;
import io.sealights.onpremise.agents.buildscanner.groovy.GroovyFileHandler;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.commons.AnnotationsExcludedFilter;
import io.sealights.onpremise.agents.commons.instrument.types.ClassSignature;
import io.sealights.onpremise.agents.commons.instrument.utils.ClassSignatureFactory;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import io.sealights.onpremise.agents.infra.filters.IncludeExcludeFilter;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.instrument.filters.MethodSignatureExcludeFilter;
import io.sealights.onpremise.agents.instrument.filters.custom.CustomMethodExcludeRules;
import io.sealights.onpremise.agents.instrument.filters.custom.CustomRulesReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;

public class FilesScanner
extends ClassFilesScanner<BuildScanData> {
    private static Logger LOG = LogFactory.getLogger(FilesScanner.class);
    private ScanConfigurationInfo configurationInfo;
    private BuildScanData scanData = new BuildScanData();
    private MethodSignatureExcludeFilter.CustomExcludeMethodFilter customExcludeMethodFilter;
    private AnnotationsExcludedFilter annotationsExcludedFilter;

    public FilesScanner(ScanModeArguments scanArguments, ScanConfigurationInfo configurationInfo) {
        super(scanArguments);
        this.configurationInfo = configurationInfo;
        this.tryResolveSourcesDir();
        this.initCustomRulesFilter();
        this.annotationsExcludedFilter = new AnnotationsExcludedFilter(configurationInfo.getClassAnnotationsExcluded());
    }

    @Override
    public BuildScanData scan() {
        BuildScanData scanResult = (BuildScanData)super.scan();
        GroovyHandlingMonitor.INSTANCE.notifySourcesStatus();
        return scanResult;
    }

    @Override
    protected IncludeExcludeFilter createPackagesFilter() {
        return IncludeExcludeFilterFactory.createPackagesFilter(this.getScanArguments());
    }

    @Override
    protected ClassSignature createClassSignature(InputStream classStream) {
        return ClassSignatureFactory.createSignature(classStream, this.createSignatureConfiguration(), this.customExcludeMethodFilter);
    }

    @Override
    protected void appendClassSignature(ClassSignature classSignature) {
        if (classSignature.isGroovyClass() && this.scanData.getSourcesDirectory() != null) {
            GroovyHandlingMonitor.INSTANCE.notifyGroovyDetected();
            this.updateBySourceData(classSignature);
        }
        String className = classSignature.getClassName();
        if (!this.scanData.getClassSignatures().containsKey(className)) {
            this.scanData.getClassSignatures().put(className, classSignature);
        } else {
            ClassSignature existedSignature = this.scanData.getClassSignatures().get(className);
            existedSignature.addMethods(classSignature.getMethods());
            existedSignature.getLines().addAll(classSignature.getLines());
        }
    }

    private void updateBySourceData(ClassSignature classSignature) {
        String relativePath = classSignature.getRelativePath();
        try {
            String sourceCode = this.readSourceCode(relativePath);
            GroovyFileHandler groovyFileHandler = new GroovyFileHandler(classSignature, sourceCode);
            groovyFileHandler.updateFromSource();
            GroovyHandlingMonitor.INSTANCE.setSourcesMatch(true);
        }
        catch (Exception e) {
            LOG.error("Could not read source code for file '{}', Error: '{}'", (Object)relativePath, (Object)e);
        }
    }

    protected ClassSignatureFactory.SignatureConfiguration createSignatureConfiguration() {
        return new ClassSignatureFactory.SignatureConfiguration(ClassSignatureFactory.SignatureConfiguration.SignatureType.codeScan, this.configurationInfo.isLineCoverageEnabled(), this.configurationInfo.isIgnoreAutoGeneratedCode(), this.configurationInfo.isReportOnConstructors(), this.configurationInfo.isReportOnGettersAndSetters(), this.configurationInfo.isIgnoreMethodsWithoutLineNumbers(), this.configurationInfo.getClassAnnotationsExcluded(), this.configurationInfo.getMethodAnnotationsExcluded());
    }

    @Override
    public BuildScanData getScannedData() {
        return this.scanData;
    }

    @Override
    boolean skipAutogenerated() {
        return this.configurationInfo.isIgnoreAutoGeneratedCode();
    }

    @Override
    boolean skipByClassAnnotationsExcluded(ClassSignature classSignature) {
        return this.annotationsExcludedFilter.matchAny(classSignature.getAnnotations());
    }

    protected void initCustomRulesFilter() {
        String rulesFile = this.configurationInfo.getCustomFilterFile();
        if (StringUtils.isNotEmpty(rulesFile)) {
            CustomRulesReader reader = new CustomRulesReader(rulesFile);
            CustomMethodExcludeRules rules = reader.read();
            this.customExcludeMethodFilter = new MethodSignatureExcludeFilter.CustomExcludeMethodFilter(rules);
            if (!rules.isEmpty()) {
                AgentLifeCycle.notifySuperUserMsg(AgentEventsController.NotifMsgLevel.INFO, String.format("scan will be executed with customRules; provided input:%s actual rules:%s", rules, this.customExcludeMethodFilter.getAggregatedRules()));
            }
        }
    }

    private String readSourceCode(String relativePath) throws IOException {
        String fullPath = PathUtils.toSystemSeparator(PathUtils.join(this.scanData.getSourcesDirectory(), relativePath));
        return FileAndFolderUtils.readFile(fullPath, StandardCharsets.UTF_8);
    }

    private void tryResolveSourcesDir() {
        String sourcesDir = StringUtils.isNotEmpty(this.getScanArguments().getSourcePath()) ? this.getScanArguments().getSourcePath() : this.getScanArguments().getWorkspacePath();
        LOG.info("Source directory resolved to be '{}'", (Object)sourcesDir);
        if (!this.verifySourcesDir(sourcesDir)) {
            return;
        }
        this.scanData.setSourcesDirectory(sourcesDir);
    }

    private boolean verifySourcesDir(String sourcesDir) {
        if (!FileAndFolderUtils.verifyFolderExists(sourcesDir)) {
            GroovyHandlingMonitor.INSTANCE.setFolderNotExistsError(sourcesDir);
            LOG.warn("Sources folder '{}' not exists, source scanning skipped", (Object)sourcesDir);
            return false;
        }
        if (!this.isFileCanRead(sourcesDir)) {
            GroovyHandlingMonitor.INSTANCE.setCannotReadError(sourcesDir);
            LOG.warn("Cant read sources folder '{}', source scanning skipped", (Object)sourcesDir);
            return false;
        }
        return true;
    }

    private boolean isFileCanRead(String filepath) {
        File file = new File(filepath);
        try {
            return file.canRead();
        }
        catch (Exception e) {
            LOG.warn("Error while trying resolve permissions for '{}'. Error: {}", (Object)filepath, (Object)e);
            return false;
        }
    }

    @Generated
    public ScanConfigurationInfo getConfigurationInfo() {
        return this.configurationInfo;
    }

    @Generated
    public BuildScanData getScanData() {
        return this.scanData;
    }

    @Generated
    public MethodSignatureExcludeFilter.CustomExcludeMethodFilter getCustomExcludeMethodFilter() {
        return this.customExcludeMethodFilter;
    }

    @Generated
    public AnnotationsExcludedFilter getAnnotationsExcludedFilter() {
        return this.annotationsExcludedFilter;
    }

    @Generated
    public void setConfigurationInfo(ScanConfigurationInfo configurationInfo) {
        this.configurationInfo = configurationInfo;
    }

    @Generated
    public void setScanData(BuildScanData scanData) {
        this.scanData = scanData;
    }

    @Generated
    public void setCustomExcludeMethodFilter(MethodSignatureExcludeFilter.CustomExcludeMethodFilter customExcludeMethodFilter) {
        this.customExcludeMethodFilter = customExcludeMethodFilter;
    }

    @Generated
    public void setAnnotationsExcludedFilter(AnnotationsExcludedFilter annotationsExcludedFilter) {
        this.annotationsExcludedFilter = annotationsExcludedFilter;
    }

    @Override
    @Generated
    public String toString() {
        return "FilesScanner(configurationInfo=" + this.getConfigurationInfo() + ", scanData=" + this.getScanData() + ", customExcludeMethodFilter=" + this.getCustomExcludeMethodFilter() + ", annotationsExcludedFilter=" + this.getAnnotationsExcludedFilter() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilesScanner)) {
            return false;
        }
        FilesScanner other = (FilesScanner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ScanConfigurationInfo this$configurationInfo = this.getConfigurationInfo();
        ScanConfigurationInfo other$configurationInfo = other.getConfigurationInfo();
        if (this$configurationInfo == null ? other$configurationInfo != null : !((Object)this$configurationInfo).equals(other$configurationInfo)) {
            return false;
        }
        BuildScanData this$scanData = this.getScanData();
        BuildScanData other$scanData = other.getScanData();
        if (this$scanData == null ? other$scanData != null : !((Object)this$scanData).equals(other$scanData)) {
            return false;
        }
        MethodSignatureExcludeFilter.CustomExcludeMethodFilter this$customExcludeMethodFilter = this.getCustomExcludeMethodFilter();
        MethodSignatureExcludeFilter.CustomExcludeMethodFilter other$customExcludeMethodFilter = other.getCustomExcludeMethodFilter();
        if (this$customExcludeMethodFilter == null ? other$customExcludeMethodFilter != null : !this$customExcludeMethodFilter.equals(other$customExcludeMethodFilter)) {
            return false;
        }
        AnnotationsExcludedFilter this$annotationsExcludedFilter = this.getAnnotationsExcludedFilter();
        AnnotationsExcludedFilter other$annotationsExcludedFilter = other.getAnnotationsExcludedFilter();
        return !(this$annotationsExcludedFilter == null ? other$annotationsExcludedFilter != null : !this$annotationsExcludedFilter.equals(other$annotationsExcludedFilter));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FilesScanner;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        ScanConfigurationInfo $configurationInfo = this.getConfigurationInfo();
        result = result * 59 + ($configurationInfo == null ? 43 : ((Object)$configurationInfo).hashCode());
        BuildScanData $scanData = this.getScanData();
        result = result * 59 + ($scanData == null ? 43 : ((Object)$scanData).hashCode());
        MethodSignatureExcludeFilter.CustomExcludeMethodFilter $customExcludeMethodFilter = this.getCustomExcludeMethodFilter();
        result = result * 59 + ($customExcludeMethodFilter == null ? 43 : $customExcludeMethodFilter.hashCode());
        AnnotationsExcludedFilter $annotationsExcludedFilter = this.getAnnotationsExcludedFilter();
        result = result * 59 + ($annotationsExcludedFilter == null ? 43 : $annotationsExcludedFilter.hashCode());
        return result;
    }
}

