/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.scan;

import io.sealights.onpremise.agents.infra.filters.IncludeExcludeFilter;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class FilesCollector {
    public static List<String> collectWithFilter(String rootpath, Boolean recursive, IncludeExcludeFilter filter) {
        if (rootpath == null) {
            throw new RuntimeException("The specified path " + rootpath + " is not a folder nor a file");
        }
        ArrayList<String> result = new ArrayList<String>();
        File rootDir = new File(rootpath);
        if (rootDir.isFile()) {
            if (filter.filter(rootpath, false)) {
                result.add(rootpath);
            }
            return result;
        }
        if (rootDir.isDirectory()) {
            return FilesCollector.search(rootDir, recursive, filter);
        }
        return result;
    }

    private static List<String> search(File directory, Boolean recursive, IncludeExcludeFilter filter) {
        ArrayList<String> returnedFiles = new ArrayList<String>();
        if (!directory.isDirectory()) {
            throw new RuntimeException("The specified directory is not a valid directory: " + directory);
        }
        if (!directory.canRead()) {
            throw new RuntimeException("There is no permission to read from the specified directory: " + directory);
        }
        for (File fileOrFolder : directory.listFiles()) {
            if (fileOrFolder.isDirectory() && recursive.booleanValue()) {
                returnedFiles.addAll(FilesCollector.search(fileOrFolder, recursive, filter));
                continue;
            }
            if (!filter.filter(fileOrFolder.getAbsolutePath(), false)) continue;
            returnedFiles.add(fileOrFolder.getAbsoluteFile().toString());
        }
        return returnedFiles;
    }
}

