/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.scan;

import io.sealights.onpremise.agents.commons.instrument.utils.ClassNameConverter;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;

public class FileErrorsContainer {
    private List<FileInfo> data = new ArrayList<FileInfo>();

    public void addFileError(String fileName, Throwable error) {
        this.data.add(new FileInfo(fileName, error.toString()));
    }

    public void addFileError(String className, String fileName, Throwable error) {
        this.data.add(new FileInfo(String.format("%s, class: %s", fileName, ClassNameConverter.binaryToClassName(className)), error.toString()));
    }

    public void notifyErrors(String message) {
        if (!this.data.isEmpty()) {
            AgentLifeCycle.notifyWarningMsg(message + this.data.toString());
        }
    }

    @Generated
    public FileErrorsContainer() {
    }

    @Generated
    public List<FileInfo> getData() {
        return this.data;
    }

    @Generated
    public void setData(List<FileInfo> data2) {
        this.data = data2;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileErrorsContainer)) {
            return false;
        }
        FileErrorsContainer other = (FileErrorsContainer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<FileInfo> this$data = this.getData();
        List<FileInfo> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FileErrorsContainer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<FileInfo> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FileErrorsContainer(data=" + this.getData() + ")";
    }

    public static class FileInfo {
        private String fileName;
        private String errorMsg;

        public String toString() {
            return String.format("(file: %s, error: %s)", this.fileName, this.errorMsg);
        }

        @Generated
        public String getFileName() {
            return this.fileName;
        }

        @Generated
        public String getErrorMsg() {
            return this.errorMsg;
        }

        @Generated
        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Generated
        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileInfo)) {
                return false;
            }
            FileInfo other = (FileInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            String this$errorMsg = this.getErrorMsg();
            String other$errorMsg = other.getErrorMsg();
            return !(this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FileInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            String $errorMsg = this.getErrorMsg();
            result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
            return result;
        }

        @ConstructorProperties(value={"fileName", "errorMsg"})
        @Generated
        public FileInfo(String fileName, String errorMsg) {
            this.fileName = fileName;
            this.errorMsg = errorMsg;
        }
    }
}

