/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.scan;

import io.sealights.onpremise.agents.buildscanner.execmode.IncludeExcludeFilterFactory;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.FileErrorsContainer;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.FilesCollector;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.commons.filefilters.Constants;
import io.sealights.onpremise.agents.commons.instrument.types.AnnotationInfo;
import io.sealights.onpremise.agents.commons.instrument.types.ClassSignature;
import io.sealights.onpremise.agents.infra.filters.IncludeExcludeFilter;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.logging.LogLevelToStringFormatter;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class ClassFilesScanner<T> {
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static Logger LOG = LogFactory.getLogger(ClassFilesScanner.class);
    private static final String GENERATED = "Generated";
    public static final String JAR_EXT = ".jar";
    public static final String WAR_EXT = ".war";
    public static final String EAR_EXT = ".ear";
    private static final String NO_MATCHING_FILE_FOUND = "No matching files were found. ";
    private static final String EXACT_FILE_NAME_MSG = "The exact name is provided for included file, add the '*' before the file name and retry.";
    private static final String EXACT_FILE_PATH_NAME_MSG = "The exact path and name is provided for included file, validate that path is correct or add the '*' before the file name and retry.";
    private static final String CREATE_SIGNATURE_FAILURES = "Create class-signature failures: ";
    private FileErrorsContainer errorsContainer = new FileErrorsContainer();
    private ScanModeArguments scanArguments;
    private IncludeExcludeFilter packagesFilter;

    public ClassFilesScanner(ScanModeArguments scanArguments) {
        this.scanArguments = scanArguments;
        this.packagesFilter = this.createPackagesFilter();
    }

    public T scan() {
        List<String> collectedFiles = this.collectFilesNames4Scanning();
        if (collectedFiles.size() != 0) {
            String workspacePath = this.scanArguments.getWorkspacePath().replace('\\', '/');
            for (int i = 0; i < collectedFiles.size(); ++i) {
                String file = collectedFiles.get(i);
                if (!this.isArchive(file) && !this.isClassFile(file)) {
                    LOG.info("[Skipping file] - {} because it is not an archive or *.class file.", (Object)file);
                    continue;
                }
                if (this.isArchive(file)) {
                    this.handleArchive(file);
                    continue;
                }
                if (this.isClassFile(file)) {
                    this.handleClassFile(workspacePath, file);
                    continue;
                }
                LOG.error("Not an archive or *.class file. We shouldn't get here.");
            }
            this.errorsContainer.notifyErrors(CREATE_SIGNATURE_FAILURES);
        } else {
            LOG.warn("No files to scan.");
        }
        return this.getScannedData();
    }

    protected List<String> collectFilesNames4Scanning() {
        IncludeExcludeFilter filesFilter = IncludeExcludeFilterFactory.createFilesFilter(this.scanArguments);
        List<String> collectedFiles = FilesCollector.collectWithFilter(this.scanArguments.getWorkspacePath(), this.scanArguments.isRecursive(), filesFilter);
        if (collectedFiles == null || collectedFiles.isEmpty()) {
            String msg = this.emptyScanReasonDiagnostic();
            CONSOLE_LOG.info(msg);
            LOG.warn(msg);
        } else {
            LOG.info("found {} files to be scanned (full print in DEBUG)", (Object)collectedFiles.size());
            LOG.debug("files to be scanned:\n{}", (Object)LogLevelToStringFormatter.toString(Level.DEBUG, collectedFiles));
        }
        return collectedFiles;
    }

    private String emptyScanReasonDiagnostic() {
        String filesIncluded = this.scanArguments.getFilesIncluded();
        if (StringUtils.isNotEmpty(filesIncluded)) {
            boolean fileNameOnly;
            boolean exactMatch = filesIncluded.indexOf(42) == -1;
            boolean bl = fileNameOnly = filesIncluded.indexOf(File.separatorChar) == -1;
            if (exactMatch && fileNameOnly) {
                return "No matching files were found. The exact name is provided for included file, add the '*' before the file name and retry.";
            }
            if (exactMatch && !fileNameOnly) {
                return "No matching files were found. The exact path and name is provided for included file, validate that path is correct or add the '*' before the file name and retry.";
            }
        }
        return NO_MATCHING_FILE_FOUND;
    }

    protected void handleClassFile(String workspacePath, String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            LOG.warn("File not found:'{}'", (Object)filePath);
            return;
        }
        try (FileInputStream classStream = new FileInputStream(filePath);){
            this.handleClassSignature(this.extractClassName(workspacePath, filePath), classStream);
        }
        catch (Exception e) {
            this.addFileError(filePath, e);
        }
    }

    protected void handleArchive(String archivePath) {
        LOG.info("Handling archive '{}'", (Object)archivePath);
        ZipFile zipFile = null;
        Enumeration<? extends ZipEntry> entries = null;
        try {
            zipFile = new ZipFile(archivePath);
            entries = zipFile.entries();
        }
        catch (Exception e) {
            String errorMsg = String.format("Invalid file '%s'; error:%s", archivePath, e.getMessage());
            CONSOLE_LOG.println(errorMsg);
            return;
        }
        try {
            while (entries.hasMoreElements()) {
                ZipEntry zipEntry = entries.nextElement();
                String entryName = zipEntry.getName();
                if (entryName.endsWith(".class")) {
                    LOG.debug("Handling zip class-entry '{}'", (Object)entryName);
                    InputStream classStream = zipFile.getInputStream(zipEntry);
                    this.handleClassSignature(entryName, classStream);
                    continue;
                }
                if (!entryName.endsWith(JAR_EXT) || !this.isEmbeddedJarRelevant(entryName)) continue;
                this.handleEmbedJar(zipEntry, zipFile);
            }
            zipFile.close();
        }
        catch (Exception e) {
            this.addFileError(archivePath, e);
        }
    }

    protected void handleEmbedJar(ZipEntry zipEntry, ZipFile parentZipFile) {
        LOG.info("Handling embedded jar '{}'", (Object)zipEntry.getName());
        try (JarInputStream is = new JarInputStream(parentZipFile.getInputStream(zipEntry));){
            JarEntry jarEntry;
            while ((jarEntry = is.getNextJarEntry()) != null) {
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class")) continue;
                LOG.debug("Handling jar-embedded class '{}'", (Object)jarEntry.getName());
                this.handleClassSignature(jarEntry.getName(), is);
            }
        }
        catch (Exception e) {
            this.addFileError(zipEntry.getName(), e);
        }
    }

    private String extractClassName(String workspacePath, String filePath) {
        String className;
        int indexOfWorkspacePath = (filePath = filePath.replace('\\', '/')).indexOf(workspacePath);
        if (indexOfWorkspacePath > -1) {
            filePath = filePath.substring(indexOfWorkspacePath);
        }
        if ((className = filePath.replace(workspacePath, "")).indexOf(47) == 0) {
            className = className.substring(1);
        }
        return className;
    }

    private void handleClassSignature(String classFileName, InputStream classStream) {
        try {
            classFileName = this.stripWebInfPrefix(classFileName);
            for (Pattern pattern : Constants.ALWAYS_EXCLUDED_FROM_SCAN) {
                if (!pattern.matcher(classFileName).matches()) continue;
                LOG.debug("Class '{}' was skipped, it is always excluded", (Object)classFileName);
                return;
            }
            ClassSignature classSignature = this.createClassSignature(classStream);
            if (this.skipAutogenerated() && this.isGeneratedClass(classSignature)) {
                LOG.debug("Class '{}' was skipped as generated", (Object)classFileName);
            } else if (this.skipByClassAnnotationsExcluded(classSignature)) {
                LOG.info("Class '{}' was skipped as annotated with one of classAnnotationsExcluded", (Object)classFileName);
            } else if (this.getPackagesFilter().filter(classSignature.getClassName())) {
                this.appendClassSignature(classSignature);
            } else {
                LOG.debug("Class '{}' was skipped due to filter:'{}'", (Object)classFileName, (Object)this.getPackagesFilter());
            }
        }
        catch (Exception e) {
            this.addFileError(classFileName, e);
        }
    }

    private boolean isGeneratedClass(ClassSignature classSignature) {
        for (AnnotationInfo annotationInfo : classSignature.getAnnotations()) {
            if (!annotationInfo.getName().contains(GENERATED)) continue;
            return true;
        }
        return false;
    }

    private String stripWebInfPrefix(String classFileName) {
        String webInfPrefix = "WEB-INF/classes/";
        if (classFileName.startsWith("WEB-INF/classes/")) {
            return classFileName.substring("WEB-INF/classes/".length());
        }
        return classFileName;
    }

    protected static String asPackage(String file) {
        return file.replace("/", ".");
    }

    protected boolean isEmbeddedJarRelevant(String jarName) {
        return true;
    }

    private boolean isArchive(String file) {
        String fileNameLowerCase = file.toLowerCase();
        return fileNameLowerCase.endsWith(JAR_EXT) || fileNameLowerCase.endsWith(WAR_EXT) || fileNameLowerCase.endsWith(EAR_EXT);
    }

    private boolean isClassFile(String file) {
        String fileNameLowerCase = file.toLowerCase();
        return fileNameLowerCase.endsWith(".class");
    }

    private void addFileError(String fileName, Exception error) {
        this.getErrorsContainer().addFileError(fileName, error);
        LOG.error("Failed to scan '{}', e", (Object)fileName, (Object)error);
    }

    public abstract T getScannedData();

    protected abstract IncludeExcludeFilter createPackagesFilter();

    protected abstract ClassSignature createClassSignature(InputStream var1);

    abstract void appendClassSignature(ClassSignature var1);

    abstract boolean skipAutogenerated();

    abstract boolean skipByClassAnnotationsExcluded(ClassSignature var1);

    @Generated
    public FileErrorsContainer getErrorsContainer() {
        return this.errorsContainer;
    }

    @Generated
    public ScanModeArguments getScanArguments() {
        return this.scanArguments;
    }

    @Generated
    public IncludeExcludeFilter getPackagesFilter() {
        return this.packagesFilter;
    }

    @Generated
    public void setErrorsContainer(FileErrorsContainer errorsContainer) {
        this.errorsContainer = errorsContainer;
    }

    @Generated
    public void setScanArguments(ScanModeArguments scanArguments) {
        this.scanArguments = scanArguments;
    }

    @Generated
    public void setPackagesFilter(IncludeExcludeFilter packagesFilter) {
        this.packagesFilter = packagesFilter;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClassFilesScanner)) {
            return false;
        }
        ClassFilesScanner other = (ClassFilesScanner)o;
        if (!other.canEqual(this)) {
            return false;
        }
        FileErrorsContainer this$errorsContainer = this.getErrorsContainer();
        FileErrorsContainer other$errorsContainer = other.getErrorsContainer();
        if (this$errorsContainer == null ? other$errorsContainer != null : !((Object)this$errorsContainer).equals(other$errorsContainer)) {
            return false;
        }
        ScanModeArguments this$scanArguments = this.getScanArguments();
        ScanModeArguments other$scanArguments = other.getScanArguments();
        if (this$scanArguments == null ? other$scanArguments != null : !((Object)this$scanArguments).equals(other$scanArguments)) {
            return false;
        }
        IncludeExcludeFilter this$packagesFilter = this.getPackagesFilter();
        IncludeExcludeFilter other$packagesFilter = other.getPackagesFilter();
        return !(this$packagesFilter == null ? other$packagesFilter != null : !this$packagesFilter.equals(other$packagesFilter));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClassFilesScanner;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        FileErrorsContainer $errorsContainer = this.getErrorsContainer();
        result = result * 59 + ($errorsContainer == null ? 43 : ((Object)$errorsContainer).hashCode());
        ScanModeArguments $scanArguments = this.getScanArguments();
        result = result * 59 + ($scanArguments == null ? 43 : ((Object)$scanArguments).hashCode());
        IncludeExcludeFilter $packagesFilter = this.getPackagesFilter();
        result = result * 59 + ($packagesFilter == null ? 43 : $packagesFilter.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ClassFilesScanner(errorsContainer=" + this.getErrorsContainer() + ", scanArguments=" + this.getScanArguments() + ", packagesFilter=" + this.getPackagesFilter() + ")";
    }
}

