/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.poms;

import io.sealights.agents.infra.integration.SeaLightsPluginInfo;
import io.sealights.onpremise.agents.buildscanner.execmode.poms.IntegrationException;
import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;
import io.sealights.onpremise.agents.buildscanner.main.inputvalidator.BuildSessionInput;
import io.sealights.onpremise.agents.buildscanner.main.inputvalidator.BuildSessionInputValidator;
import io.sealights.onpremise.agents.buildscanner.main.inputvalidator.PullRequestBuildSessionInput;
import io.sealights.onpremise.agents.buildscanner.main.inputvalidator.PullRequestBuildSessionInputValidator;
import io.sealights.onpremise.agents.infra.configuration.validation.BuildSessionFlow;
import io.sealights.onpremise.agents.infra.configuration.validation.BuildSessionIdFlowResolver;
import io.sealights.onpremise.agents.infra.configuration.validation.PluginConfigPackagesIncludedValidator;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.utils.StringUtils;

public class SealightsPluginInfoValidator {
    private final BuildSessionInputValidator buildSessionInputValidator = new BuildSessionInputValidator(new PluginConfigPackagesIncludedValidator());
    private final PullRequestBuildSessionInputValidator pullRequestBuildSessionInputValidator = new PullRequestBuildSessionInputValidator(new PluginConfigPackagesIncludedValidator());

    public void validate(SeaLightsPluginInfo pluginInfo, ModesOptions.ExecMode execMode) {
        String token = pluginInfo.getToken();
        String tokenFile = pluginInfo.getTokenFile();
        if (StringUtils.isNullOrEmpty(token) && StringUtils.isNullOrEmpty(tokenFile)) {
            throw new IntegrationException("both 'token' and 'tokenFile' cannot be null");
        }
        BuildSessionFlow bsidFlow = BuildSessionIdFlowResolver.resolveFlow(pluginInfo.isCreateBuildSessionId(), pluginInfo.isCreatePRBuildSessionId());
        switch (bsidFlow) {
            case CREATE_BUILD_SESSION: {
                this.validateCreateBuildSessionInput(pluginInfo, execMode);
                break;
            }
            case CREATE_PR_BUILD_SESSION: {
                this.validateCreatePullRequestBuildSessionInput(pluginInfo, execMode);
                break;
            }
            case RESOLVE_EXISTING_SESSION: {
                this.validateExistingBuildSessionInput(pluginInfo);
                break;
            }
            case ERROR_AMBIGUOUS_PARAMS: {
                throw new IntegrationException("Ambiguous data: createPRBuildSessionId = true and createBuildSessionId=true, cannot create build session id.");
            }
        }
    }

    private void validateCreatePullRequestBuildSessionInput(SeaLightsPluginInfo pluginInfo, ModesOptions.ExecMode execMode) {
        ValidationResult validationResult = this.pullRequestBuildSessionInputValidator.validate(execMode, new PullRequestBuildSessionInput(pluginInfo.getBuildSessionId(), pluginInfo.getAppName(), pluginInfo.getRepositoryUrl(), pluginInfo.getPullRequestNumber(), pluginInfo.getLatestCommit(), pluginInfo.getTargetBranch(), pluginInfo.getPackagesIncluded()));
        if (!validationResult.isValid()) {
            throw new IntegrationException(String.format("'createPRBuildSessionId' is true, but the following errors were detected: %s", validationResult.toStringErrors()));
        }
    }

    private void validateCreateBuildSessionInput(SeaLightsPluginInfo pluginInfo, ModesOptions.ExecMode execMode) {
        ValidationResult validationResult = this.buildSessionInputValidator.validate(execMode, new BuildSessionInput(pluginInfo.getBuildSessionId(), pluginInfo.getAppName(), pluginInfo.getBuildName(), pluginInfo.getBranchName(), pluginInfo.getPackagesIncluded()));
        if (!validationResult.isValid()) {
            throw new IntegrationException(String.format("'createBuildSessionId' is true, but the following errors were detected: %s", validationResult.toStringErrors()));
        }
    }

    private void validateExistingBuildSessionInput(SeaLightsPluginInfo pluginInfo) {
        if (StringUtils.isNullOrEmpty(pluginInfo.getBuildSessionIdFile()) && StringUtils.isNullOrEmpty(pluginInfo.getBuildSessionId()) && StringUtils.isNullOrEmpty(pluginInfo.getLabId())) {
            throw new IntegrationException("'createBuildSessionId' is false, either 'buildSessionId' or 'labId' must be provided");
        }
    }

    public BuildSessionInputValidator getBuildSessionInputValidator() {
        return this.buildSessionInputValidator;
    }
}

