/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.poms;

import io.sealights.onpremise.agents.buildscanner.execmode.ModeExecutor;
import io.sealights.onpremise.agents.buildscanner.main.cli.ExecModeArguments;
import io.sealights.onpremise.agents.buildscanner.main.cli.plugins.PomRestoreArguments;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.token.TokenData;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.PathUtils;
import io.sealights.onpremise.agents.infra.utils.TextFileUtils;
import java.io.File;
import java.io.IOException;
import java.util.List;
import lombok.Generated;

public class PomRestoreModeExecutor
extends ModeExecutor<PomRestoreArguments> {
    public static final String POM_FILE_EXTENSION = "pom.xml";
    public static final String SLBACK_FILE_EXTENSION = "pom.xml.slback";
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private List<File> pomFiles;
    private List<File> slbackFiles;
    private final String workspacePath;
    private boolean isSuccess = true;

    public PomRestoreModeExecutor(PomRestoreArguments arguments) {
        super(arguments);
        this.workspacePath = arguments.getWorkspacePath();
    }

    @Override
    public boolean execute() {
        this.deleteSyntheticParentPoms();
        this.collectFiles();
        if (!this.validateFileLists()) {
            this.isSuccess = false;
        }
        this.deletePomFiles();
        this.renameSlbackFiles();
        return this.isSuccess;
    }

    void deleteSyntheticParentPoms() {
        if (!this.isSuccess) {
            return;
        }
        String reminderFilePath = PathUtils.join(this.workspacePath, "syntheticParentPomPath.slback");
        File reminderFile = new File(reminderFilePath);
        try {
            if (!reminderFile.exists()) {
                return;
            }
            String syntheticParentPomFilePaths = TextFileUtils.getContent(reminderFilePath);
            boolean deletedSyntheticPoms = true;
            for (String syntheticParentPomFilePath : syntheticParentPomFilePaths.split("\n")) {
                deletedSyntheticPoms = this.deleteSyntheticPom(syntheticParentPomFilePath.trim()) && deletedSyntheticPoms;
            }
            boolean deletedReminderFile = reminderFile.delete();
            if (!deletedReminderFile) {
                CONSOLE_LOG.error("Failed to delete the file '" + reminderFilePath + "'");
            }
            this.isSuccess = deletedSyntheticPoms && deletedReminderFile;
        }
        catch (IOException e) {
            CONSOLE_LOG.error("Error during deletion of synthetic parent pom file (path contained in '" + reminderFilePath + "'");
            this.isSuccess = false;
        }
    }

    private boolean deleteSyntheticPom(String syntheticParentPomFilePath) {
        try {
            File syntheticParentPomFile = new File(syntheticParentPomFilePath);
            if (syntheticParentPomFile.delete()) {
                return true;
            }
            CONSOLE_LOG.error("Failed to delete the file '" + syntheticParentPomFilePath + "'");
        }
        catch (Exception e) {
            CONSOLE_LOG.error("Failed to delete the file '" + syntheticParentPomFilePath + "'", e);
        }
        return false;
    }

    private boolean validateFileLists() {
        if (this.pomFiles.isEmpty()) {
            CONSOLE_LOG.error("cannot find sealights integrated files (pom.xml).");
            return false;
        }
        if (this.slbackFiles.isEmpty()) {
            CONSOLE_LOG.error("cannot find the original pom files (pom.xml.slback).");
            return false;
        }
        return true;
    }

    @Override
    public TokenData searchAndExtractTokenData(ExecModeArguments args) {
        return new TokenData();
    }

    private void collectRecursively() {
        this.pomFiles = FileAndFolderUtils.collectFilesByExtentionRecursively(((PomRestoreArguments)this.getArguments()).getWorkspacePath(), POM_FILE_EXTENSION);
        this.slbackFiles = FileAndFolderUtils.collectFilesByExtentionRecursively(((PomRestoreArguments)this.getArguments()).getWorkspacePath(), SLBACK_FILE_EXTENSION);
    }

    private void collectFiles() {
        if (((PomRestoreArguments)this.getArguments()).isRecursive()) {
            this.collectRecursively();
        } else {
            this.pomFiles = FileAndFolderUtils.collectFolderFilesByExtention(((PomRestoreArguments)this.getArguments()).getWorkspacePath(), POM_FILE_EXTENSION);
            this.slbackFiles = FileAndFolderUtils.collectFolderFilesByExtention(((PomRestoreArguments)this.getArguments()).getWorkspacePath(), SLBACK_FILE_EXTENSION);
        }
    }

    private void deletePomFiles() {
        if (!this.isSuccess) {
            return;
        }
        for (File pomFile : this.pomFiles) {
            if (pomFile.delete()) {
                CONSOLE_LOG.info("file '" + pomFile.getAbsolutePath() + "' deleted successfully");
                continue;
            }
            this.isSuccess = false;
            CONSOLE_LOG.error("Failed to delete the file '" + pomFile.getAbsolutePath() + "'");
        }
    }

    private void renameSlbackFiles() {
        if (!this.isSuccess) {
            return;
        }
        for (File slbackFile : this.slbackFiles) {
            String newName;
            if (slbackFile.renameTo(new File(newName = slbackFile.getAbsolutePath().replace(SLBACK_FILE_EXTENSION, POM_FILE_EXTENSION)))) {
                CONSOLE_LOG.info("file '" + slbackFile.getAbsolutePath() + "' renamed successfully");
                continue;
            }
            this.isSuccess = false;
            CONSOLE_LOG.error("Failed to rename the file '" + slbackFile.getAbsolutePath() + "'");
        }
    }

    @Generated
    boolean isSuccess() {
        return this.isSuccess;
    }
}

