/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.poms;

import io.sealights.agents.infra.integration.PluginVersionResolver;
import io.sealights.agents.infra.integration.SeaLightsPluginInfo;
import io.sealights.agents.infra.integration.maven.ExternalParentPomFinder;
import io.sealights.agents.infra.integration.maven.PomFilesCollector;
import io.sealights.agents.infra.integration.maven.entities.CollectedPomFiles;
import io.sealights.agents.infra.integration.maven.integration.MavenIntegration;
import io.sealights.agents.infra.integration.maven.integration.MavenIntegrationInfo;
import io.sealights.onpremise.agents.buildscanner.execmode.ModeExecutor;
import io.sealights.onpremise.agents.buildscanner.execmode.poms.IntegrationException;
import io.sealights.onpremise.agents.buildscanner.execmode.poms.PluginInfoReader;
import io.sealights.onpremise.agents.buildscanner.execmode.poms.SealightsPluginInfoValidator;
import io.sealights.onpremise.agents.buildscanner.main.cli.ExecModeArguments;
import io.sealights.onpremise.agents.buildscanner.main.cli.plugins.PomIntegrationArguments;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.token.TokenData;
import io.sealights.onpremise.agents.infra.token.TokenParser;
import io.sealights.onpremise.agents.infra.types.Component;
import io.sealights.onpremise.agents.infra.utils.ArgumentFileReader;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.beans.ConstructorProperties;
import lombok.Generated;

public class PomIntegrationModeExecutor
extends ModeExecutor<PomIntegrationArguments> {
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private PomFilesCollector filesCollector;
    private String rawToken;
    private MavenIntegration mavenIntegration;
    private final SealightsPluginInfoValidator pluginInfoValidator;
    private final PluginInfoReader pluginInfoReader;
    private final PluginVersionResolver pluginVersionResolver;

    public PomIntegrationModeExecutor(PomIntegrationArguments arguments, PomFilesCollector filesCollector, PluginInfoReader pluginInfoReader, PluginVersionResolver pluginVersionResolver) {
        super(arguments);
        this.filesCollector = filesCollector;
        this.pluginInfoReader = pluginInfoReader;
        this.pluginInfoValidator = new SealightsPluginInfoValidator();
        this.pluginVersionResolver = pluginVersionResolver;
    }

    public PomIntegrationModeExecutor(PomIntegrationArguments arguments) {
        this(arguments, new PomFilesCollector(PomIntegrationModeExecutor.createExternalParentPomFinder(arguments), arguments.getWorkspacePath()), new PluginInfoReader(), new PluginVersionResolver());
    }

    private static ExternalParentPomFinder createExternalParentPomFinder(PomIntegrationArguments arguments) {
        return arguments.isModifyParentPom() ? new ExternalParentPomFinder(arguments.getMavenLocalRepoPath()) : new ExternalParentPomFinder();
    }

    @Override
    public boolean execute() {
        try {
            if (!this.normalizeArgsWsPath()) {
                return false;
            }
            CollectedPomFiles collectedPomFiles = this.filesCollector.collect();
            if (collectedPomFiles.getRootPomFile() == null) {
                CONSOLE_LOG.error("Cannot find pom files, skipping sealights integration");
                return false;
            }
            SeaLightsPluginInfo seaLightsPluginInfo = this.pluginInfoReader.read(((PomIntegrationArguments)this.getArguments()).getConfigFile());
            this.resolvePluginInfoWithIntegrationToken(seaLightsPluginInfo);
            this.pluginInfoValidator.validate(seaLightsPluginInfo, ((PomIntegrationArguments)this.getArguments()).getExecMode());
            this.extractTokenData(seaLightsPluginInfo);
            String resolvedVersion = this.resolveVersion(seaLightsPluginInfo);
            MavenIntegrationInfo mavenIntegrationInfo = new MavenIntegrationInfo(collectedPomFiles, seaLightsPluginInfo, resolvedVersion);
            MavenIntegration mavenIntegration = this.createMavenIntegration(mavenIntegrationInfo);
            mavenIntegration.integrate();
            CONSOLE_LOG.info("Pom integration was completed.");
            return true;
        }
        catch (IntegrationException e) {
            CONSOLE_LOG.status("Pom integration failed with error:" + e.getMessage());
        }
        catch (Exception e) {
            CONSOLE_LOG.error("Error while integrating pom files. ", e);
        }
        return false;
    }

    private void resolvePluginInfoWithIntegrationToken(SeaLightsPluginInfo seaLightsPluginInfo) {
        if (StringUtils.isNullOrEmpty(seaLightsPluginInfo.getToken()) && StringUtils.isNullOrEmpty(seaLightsPluginInfo.getTokenFile())) {
            seaLightsPluginInfo.setToken(((PomIntegrationArguments)this.getArguments()).getIntegrationToken());
            CONSOLE_LOG.debug("integrationToken used in plugin configuration");
        }
    }

    protected MavenIntegration createMavenIntegration(MavenIntegrationInfo mavenIntegrationInfo) {
        return new MavenIntegration(mavenIntegrationInfo, false);
    }

    protected boolean normalizeArgsWsPath() {
        String wsPath = ((PomIntegrationArguments)this.getArguments()).getWorkspacePath();
        String wsAbsolutePath = FileAndFolderUtils.resolveAbsolutePath(wsPath);
        if (!FileAndFolderUtils.isFolderExists(wsAbsolutePath)) {
            CONSOLE_LOG.error("Invalid workspacepath '{}' was provided: directory '{}' does not exist; build files scanning cannot be done", (Object)wsPath, (Object)wsAbsolutePath);
            return false;
        }
        if (wsPath.equals(wsAbsolutePath)) {
            CONSOLE_LOG.info("Using the original workspacepath:'{}'", (Object)wsPath);
        } else {
            ((PomIntegrationArguments)this.getArguments()).setWorkspacePath(wsAbsolutePath);
            CONSOLE_LOG.info("The relative workspacepath:'{}' was replaced by the absolute path:'{}'", (Object)wsPath, (Object)((PomIntegrationArguments)this.getArguments()).getWorkspacePath());
        }
        return true;
    }

    @Override
    public TokenData searchAndExtractTokenData(ExecModeArguments args) {
        return new TokenData();
    }

    private void extractTokenData(SeaLightsPluginInfo pluginInfo) {
        this.rawToken = StringUtils.isNotEmpty(((PomIntegrationArguments)this.getArguments()).getIntegrationToken()) ? ((PomIntegrationArguments)this.getArguments()).getIntegrationToken() : ArgumentFileReader.resolve(pluginInfo.getToken(), pluginInfo.getTokenFile());
        this.setTokenData(TokenParser.parseAndValidate(this.rawToken));
    }

    private String resolveVersion(SeaLightsPluginInfo seaLightsPluginInfo) {
        if (StringUtils.isNotEmpty(((PomIntegrationArguments)this.getArguments()).getPluginVersion()) || !this.getTokenData().isValid()) {
            return ((PomIntegrationArguments)this.getArguments()).getPluginVersion();
        }
        return this.pluginVersionResolver.resolve(this.rawToken, seaLightsPluginInfo, Component.MAVEN_PLUGIN_COMPONENT_NAME);
    }

    @Generated
    public PomFilesCollector getFilesCollector() {
        return this.filesCollector;
    }

    @Generated
    public String getRawToken() {
        return this.rawToken;
    }

    @Generated
    public MavenIntegration getMavenIntegration() {
        return this.mavenIntegration;
    }

    @Generated
    public SealightsPluginInfoValidator getPluginInfoValidator() {
        return this.pluginInfoValidator;
    }

    @Generated
    public PluginInfoReader getPluginInfoReader() {
        return this.pluginInfoReader;
    }

    @Generated
    public PluginVersionResolver getPluginVersionResolver() {
        return this.pluginVersionResolver;
    }

    @Generated
    public void setFilesCollector(PomFilesCollector filesCollector) {
        this.filesCollector = filesCollector;
    }

    @Generated
    public void setRawToken(String rawToken) {
        this.rawToken = rawToken;
    }

    @Generated
    public void setMavenIntegration(MavenIntegration mavenIntegration) {
        this.mavenIntegration = mavenIntegration;
    }

    @Override
    @Generated
    public String toString() {
        return "PomIntegrationModeExecutor(filesCollector=" + this.getFilesCollector() + ", rawToken=" + this.getRawToken() + ", mavenIntegration=" + this.getMavenIntegration() + ", pluginInfoValidator=" + this.getPluginInfoValidator() + ", pluginInfoReader=" + this.getPluginInfoReader() + ", pluginVersionResolver=" + this.getPluginVersionResolver() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PomIntegrationModeExecutor)) {
            return false;
        }
        PomIntegrationModeExecutor other = (PomIntegrationModeExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PomFilesCollector this$filesCollector = this.getFilesCollector();
        PomFilesCollector other$filesCollector = other.getFilesCollector();
        if (this$filesCollector == null ? other$filesCollector != null : !((Object)this$filesCollector).equals(other$filesCollector)) {
            return false;
        }
        String this$rawToken = this.getRawToken();
        String other$rawToken = other.getRawToken();
        if (this$rawToken == null ? other$rawToken != null : !this$rawToken.equals(other$rawToken)) {
            return false;
        }
        MavenIntegration this$mavenIntegration = this.getMavenIntegration();
        MavenIntegration other$mavenIntegration = other.getMavenIntegration();
        if (this$mavenIntegration == null ? other$mavenIntegration != null : !this$mavenIntegration.equals(other$mavenIntegration)) {
            return false;
        }
        SealightsPluginInfoValidator this$pluginInfoValidator = this.getPluginInfoValidator();
        SealightsPluginInfoValidator other$pluginInfoValidator = other.getPluginInfoValidator();
        if (this$pluginInfoValidator == null ? other$pluginInfoValidator != null : !this$pluginInfoValidator.equals(other$pluginInfoValidator)) {
            return false;
        }
        PluginInfoReader this$pluginInfoReader = this.getPluginInfoReader();
        PluginInfoReader other$pluginInfoReader = other.getPluginInfoReader();
        if (this$pluginInfoReader == null ? other$pluginInfoReader != null : !this$pluginInfoReader.equals(other$pluginInfoReader)) {
            return false;
        }
        PluginVersionResolver this$pluginVersionResolver = this.getPluginVersionResolver();
        PluginVersionResolver other$pluginVersionResolver = other.getPluginVersionResolver();
        return !(this$pluginVersionResolver == null ? other$pluginVersionResolver != null : !this$pluginVersionResolver.equals(other$pluginVersionResolver));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PomIntegrationModeExecutor;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        PomFilesCollector $filesCollector = this.getFilesCollector();
        result = result * 59 + ($filesCollector == null ? 43 : ((Object)$filesCollector).hashCode());
        String $rawToken = this.getRawToken();
        result = result * 59 + ($rawToken == null ? 43 : $rawToken.hashCode());
        MavenIntegration $mavenIntegration = this.getMavenIntegration();
        result = result * 59 + ($mavenIntegration == null ? 43 : $mavenIntegration.hashCode());
        SealightsPluginInfoValidator $pluginInfoValidator = this.getPluginInfoValidator();
        result = result * 59 + ($pluginInfoValidator == null ? 43 : $pluginInfoValidator.hashCode());
        PluginInfoReader $pluginInfoReader = this.getPluginInfoReader();
        result = result * 59 + ($pluginInfoReader == null ? 43 : $pluginInfoReader.hashCode());
        PluginVersionResolver $pluginVersionResolver = this.getPluginVersionResolver();
        result = result * 59 + ($pluginVersionResolver == null ? 43 : $pluginVersionResolver.hashCode());
        return result;
    }

    @ConstructorProperties(value={"filesCollector", "rawToken", "mavenIntegration", "pluginInfoValidator", "pluginInfoReader", "pluginVersionResolver"})
    @Generated
    public PomIntegrationModeExecutor(PomFilesCollector filesCollector, String rawToken, MavenIntegration mavenIntegration, SealightsPluginInfoValidator pluginInfoValidator, PluginInfoReader pluginInfoReader, PluginVersionResolver pluginVersionResolver) {
        this.filesCollector = filesCollector;
        this.rawToken = rawToken;
        this.mavenIntegration = mavenIntegration;
        this.pluginInfoValidator = pluginInfoValidator;
        this.pluginInfoReader = pluginInfoReader;
        this.pluginVersionResolver = pluginVersionResolver;
    }
}

