/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.poms;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.common.base.CharMatcher;
import io.sealights.agents.infra.integration.SeaLightsPluginInfo;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class PluginInfoReader {
    private final ObjectMapper objectMapper = this.configure();
    private static final ConsoleLogger CONSOLE_LOGGER = LogFactory.createConsoleLogger();
    private static final CharMatcher UNEXPECTED_CHARACTERS_MATCHER = CharMatcher.anyOf("\r\n\t ");

    public SeaLightsPluginInfo read(String configFilePath) throws IOException {
        SeaLightsPluginInfo seaLightsPluginInfo = this.objectMapper.readValue(new File(configFilePath), SeaLightsPluginInfo.class);
        this.warnAgainstUnknownEntries(seaLightsPluginInfo, configFilePath);
        this.fixMisspellingProxyUrl(seaLightsPluginInfo, configFilePath);
        return seaLightsPluginInfo;
    }

    private void warnAgainstUnknownEntries(SeaLightsPluginInfo seaLightsPluginInfo, String configFilePath) {
        for (Map.Entry<String, String> unrecognisedField : seaLightsPluginInfo.getUnrecognisedFields().entrySet()) {
            CONSOLE_LOGGER.status("Unrecognized element '" + unrecognisedField.getKey() + "'='" + unrecognisedField.getValue() + "' in JSON configuration file '" + configFilePath + "'. Is it a misspelling?");
        }
    }

    private void fixMisspellingProxyUrl(SeaLightsPluginInfo seaLightsPluginInfo, String configFilePath) {
        String originalProxy = seaLightsPluginInfo.getProxy();
        String msgPrefix = "JSON configuration file '" + configFilePath + "'. Element proxy value '" + originalProxy + "'";
        if (StringUtils.isNullOrEmpty(originalProxy)) {
            CONSOLE_LOGGER.status(msgPrefix + ". Proxy value is not set.");
            return;
        }
        String fixedProxy = UNEXPECTED_CHARACTERS_MATCHER.replaceFrom((CharSequence)originalProxy, "");
        if (!originalProxy.equals(fixedProxy)) {
            seaLightsPluginInfo.setProxy(fixedProxy);
            CONSOLE_LOGGER.status(msgPrefix + " contains an EOL or TAB symbols or whitespace(s) that will be trimmed; new value is set to '" + fixedProxy + "'");
        }
    }

    private ObjectMapper configure() {
        return ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS)).configure(JsonParser.Feature.ALLOW_COMMENTS, true)).build();
    }
}

