/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.gradleintegration;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.sealights.agents.infra.integration.GradleProjectConfig;
import io.sealights.agents.infra.integration.SeaLightsPluginInfo;
import io.sealights.agents.infra.integration.gradle.GradleIntegration;
import io.sealights.agents.infra.integration.gradle.model.IntegrationParams;
import io.sealights.onpremise.agents.buildscanner.execmode.ModeExecutor;
import io.sealights.onpremise.agents.buildscanner.execmode.poms.PluginInfoReader;
import io.sealights.onpremise.agents.buildscanner.execmode.poms.SealightsPluginInfoValidator;
import io.sealights.onpremise.agents.buildscanner.main.cli.plugins.GradleIntegrationArguments;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.io.FileNotFoundException;

public class GradleIntegrationModeExecutor
extends ModeExecutor<GradleIntegrationArguments> {
    private static final ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private final GradleIntegration gradleIntegration;
    private final PluginInfoReader pluginInfoReader;
    private final SealightsPluginInfoValidator pluginInfoValidator;

    public GradleIntegrationModeExecutor(GradleIntegrationArguments arguments) {
        this(arguments, new GradleIntegration(), new PluginInfoReader(), new SealightsPluginInfoValidator());
    }

    public GradleIntegrationModeExecutor(GradleIntegrationArguments arguments, GradleIntegration gradleIntegration, PluginInfoReader pluginInfoReader, SealightsPluginInfoValidator pluginInfoValidator) {
        super(arguments);
        this.gradleIntegration = gradleIntegration;
        this.pluginInfoReader = pluginInfoReader;
        this.pluginInfoValidator = pluginInfoValidator;
    }

    @Override
    public boolean execute() {
        try {
            SeaLightsPluginInfo pluginInfo = this.pluginInfoReader.read(((GradleIntegrationArguments)this.getArguments()).getConfigFile());
            this.pluginInfoValidator.validate(pluginInfo, ((GradleIntegrationArguments)this.getArguments()).getExecMode());
            return this.gradleIntegration.integrate(this.createIntegrationParams(pluginInfo));
        }
        catch (FileNotFoundException fnfe) {
            CONSOLE_LOG.error(String.format("File operation error: %s", fnfe.getMessage()));
        }
        catch (JsonProcessingException jpe) {
            CONSOLE_LOG.error(String.format("Invalid config file '%s': %s", ((GradleIntegrationArguments)this.getArguments()).getConfigFile(), jpe.getMessage()));
        }
        catch (Exception e) {
            CONSOLE_LOG.error("Failed to integrate SeaLights into Gradle project", e);
        }
        return false;
    }

    @Override
    public boolean isTokenRelevant() {
        return false;
    }

    private IntegrationParams createIntegrationParams(SeaLightsPluginInfo pluginInfo) {
        if (pluginInfo.getGradleProjectConfig() == null) {
            pluginInfo.setGradleProjectConfig(new GradleProjectConfig());
        }
        this.overrideByArguments(pluginInfo);
        return new IntegrationParams(pluginInfo, ((GradleIntegrationArguments)this.getArguments()).getWorkspacePath());
    }

    private void overrideByArguments(SeaLightsPluginInfo pluginInfo) {
        if (((GradleIntegrationArguments)this.getArguments()).getPluginVersion() != null) {
            pluginInfo.setPluginVersion(((GradleIntegrationArguments)this.getArguments()).getPluginVersion());
        }
        GradleProjectConfig gradleProjectConfig = pluginInfo.getGradleProjectConfig();
        if (((GradleIntegrationArguments)this.getArguments()).getRepoConfig() != null) {
            gradleProjectConfig.setRepoConfig(((GradleIntegrationArguments)this.getArguments()).getRepoConfig());
        }
        if (((GradleIntegrationArguments)this.getArguments()).getExcludedProjects() != null) {
            gradleProjectConfig.excludedProjectsFrom(((GradleIntegrationArguments)this.getArguments()).getExcludedProjects());
        }
        if (((GradleIntegrationArguments)this.getArguments()).getIncludedProjects() != null) {
            gradleProjectConfig.includedProjectsFrom(((GradleIntegrationArguments)this.getArguments()).getIncludedProjects());
        }
        if (((GradleIntegrationArguments)this.getArguments()).isUseOnlyProjectRepoSection()) {
            gradleProjectConfig.setUseOnlyProjectRepoSection(true);
        }
    }
}

