/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.config;

import io.sealights.onpremise.agents.buildscanner.execmode.config.ArgErrorLogger;
import io.sealights.onpremise.agents.buildscanner.execmode.config.BaseConfigModeExecutor;
import io.sealights.onpremise.agents.buildscanner.main.cli.config.PrConfigModeArguments;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionServiceProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.PullRequestBuildSessionCreateData;
import io.sealights.onpremise.agents.infra.types.PullRequestParams;
import io.sealights.onpremise.agents.infra.utils.StringUtils;

public class PrConfigModeExecutor
extends BaseConfigModeExecutor<PrConfigModeArguments> {
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();

    public PrConfigModeExecutor(PrConfigModeArguments arguments) {
        super(arguments);
    }

    public PrConfigModeExecutor(PrConfigModeArguments arguments, BuildSessionServiceProxy buildSessionIdProxy) {
        super(arguments, buildSessionIdProxy);
    }

    @Override
    protected String createBuildSessionId() {
        PullRequestBuildSessionCreateData bsCreateData = this.createBuildSessionData();
        if (!this.isValidConfigurationArguments(bsCreateData)) {
            CONSOLE_LOG.printError("Invalid configuration. Please fix the above error(s).");
            return null;
        }
        return this.getBuildSessionIdProxy().createPullRequestBuildSessionId(bsCreateData, this.getBuildSessionFilePath());
    }

    private PullRequestBuildSessionCreateData createBuildSessionData() {
        PullRequestParams requestParams = new PullRequestParams(((PrConfigModeArguments)this.getArguments()).getRepositoryUrl(), Integer.parseInt(((PrConfigModeArguments)this.getArguments()).getPullRequestNumber()), ((PrConfigModeArguments)this.getArguments()).getLatestCommit(), ((PrConfigModeArguments)this.getArguments()).getTargetBranch());
        PullRequestBuildSessionCreateData bsCreateData = new PullRequestBuildSessionCreateData(((PrConfigModeArguments)this.getArguments()).getAppname(), ((PrConfigModeArguments)this.getArguments()).getPackagesIncluded(), ((PrConfigModeArguments)this.getArguments()).getPackagesExcluded(), requestParams);
        return bsCreateData;
    }

    private boolean isValidConfigurationArguments(PullRequestBuildSessionCreateData bsCreateData) {
        boolean isValid = true;
        if (StringUtils.isNullOrEmpty(((PrConfigModeArguments)this.getArguments()).getToken())) {
            ArgErrorLogger.errMissingArgs("token", "tokenfile");
            isValid = false;
        }
        if (StringUtils.isNullOrEmpty(bsCreateData.getAppName())) {
            ArgErrorLogger.warnMissingArg("appname");
        }
        if (StringUtils.isNullOrEmpty(bsCreateData.getPackagesIncluded())) {
            ArgErrorLogger.warnMissingArg("packagesincluded");
        }
        if (!this.isValidPullRequestArgs(bsCreateData.getPullRequestParams())) {
            isValid = false;
        }
        return isValid;
    }

    private boolean isValidPullRequestArgs(PullRequestParams pullRequestParams) {
        boolean isValid = true;
        if (StringUtils.isNullOrEmpty(pullRequestParams.getRepositoryUrl())) {
            ArgErrorLogger.errMissingArg("repoUrl");
            isValid = false;
        }
        if (StringUtils.isNullOrEmpty(pullRequestParams.getLatestCommit())) {
            ArgErrorLogger.errMissingArg("latestCommit");
            isValid = false;
        }
        if (pullRequestParams.getPullRequestNumber() == 0) {
            ArgErrorLogger.errMissingArg("pullRequestNumber");
            isValid = false;
        }
        if (StringUtils.isNullOrEmpty(pullRequestParams.getTargetBranch())) {
            ArgErrorLogger.errMissingArg("targetBranch");
            isValid = false;
        }
        return isValid;
    }
}

