/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.config;

import io.sealights.onpremise.agents.buildscanner.execmode.config.ArgErrorLogger;
import io.sealights.onpremise.agents.buildscanner.execmode.config.BaseConfigModeExecutor;
import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;
import io.sealights.onpremise.agents.buildscanner.main.cli.config.ConfigModeArguments;
import io.sealights.onpremise.agents.buildscanner.main.inputvalidator.BuildSessionInput;
import io.sealights.onpremise.agents.buildscanner.main.inputvalidator.BuildSessionInputValidator;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionServiceProxy;
import io.sealights.onpremise.agents.infra.types.AdditionalArgumentsData;
import io.sealights.onpremise.agents.infra.types.BuildSessionData;
import io.sealights.onpremise.agents.infra.utils.StringUtils;

public class ConfigModeExecutor
extends BaseConfigModeExecutor<ConfigModeArguments> {
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private final BuildSessionInputValidator buildSessionInputValidator;

    public ConfigModeExecutor(ConfigModeArguments arguments) {
        super(arguments);
        this.buildSessionInputValidator = new BuildSessionInputValidator();
    }

    public ConfigModeExecutor(ConfigModeArguments arguments, BuildSessionServiceProxy buildSessionIdProxy, BuildSessionInputValidator buildSessionInputValidator) {
        super(arguments, buildSessionIdProxy);
        this.buildSessionInputValidator = buildSessionInputValidator;
    }

    @Override
    protected String createBuildSessionId() {
        BuildSessionData buildSessionData = this.createBuildSessionData();
        if (!this.isValidConfigurationArguments(buildSessionData)) {
            CONSOLE_LOG.printError("Invalid configuration. Please fix the above error(s).");
            return null;
        }
        return this.getBuildSessionIdProxy().createBuildSessionId(buildSessionData, this.getBuildSessionFilePath());
    }

    private BuildSessionData createBuildSessionData() {
        AdditionalArgumentsData additionalArgumentsData = new AdditionalArgumentsData(((ConfigModeArguments)this.getArguments()).getPackagesIncluded(), ((ConfigModeArguments)this.getArguments()).getPackagesExcluded(), ((ConfigModeArguments)this.getArguments()).getIncludedNamespaces(), ((ConfigModeArguments)this.getArguments()).getExcludedNamespaces(), ((ConfigModeArguments)this.getArguments()).getIncludedFilePatterns(), ((ConfigModeArguments)this.getArguments()).getExcludedFilePatterns());
        BuildSessionData buildSessionData = new BuildSessionData(((ConfigModeArguments)this.getArguments()).getAppname(), ((ConfigModeArguments)this.getArguments()).getBuildname(), ((ConfigModeArguments)this.getArguments()).getBranchname(), ((ConfigModeArguments)this.getArguments()).getBuildSessionId(), additionalArgumentsData);
        return buildSessionData;
    }

    private boolean isValidConfigurationArguments(BuildSessionData bsData) {
        ValidationResult validationResult;
        boolean isValid = true;
        if (StringUtils.isNullOrEmpty(((ConfigModeArguments)this.getArguments()).getToken())) {
            ArgErrorLogger.errMissingArgs("token", "tokenfile");
            isValid = false;
        }
        if (!(isValid = (validationResult = this.buildSessionInputValidator.validate(ModesOptions.ExecMode.CONFIG, new BuildSessionInput(null, bsData.getAppName(), bsData.getBuildName(), bsData.getBranchName(), bsData.getAdditionalParams().getPackagesIncluded()))).isValid())) {
            ArgErrorLogger.errValidationResult(validationResult);
        }
        return isValid;
    }
}

