/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.config;

import io.sealights.onpremise.agents.buildscanner.execmode.ModeExecutor;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.ModulesScanner;
import io.sealights.onpremise.agents.buildscanner.main.cli.config.BaseConfigModeArguments;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionIdFile;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionServiceProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionServiceProxyHandler;
import io.sealights.onpremise.agents.infra.utils.FileAndFolderUtils;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import lombok.Generated;
import org.slf4j.Logger;

public abstract class BaseConfigModeExecutor<T extends BaseConfigModeArguments>
extends ModeExecutor<T> {
    private static Logger LOG = LogFactory.getLogger(ModulesScanner.class);
    private BuildSessionServiceProxy buildSessionIdProxy;

    public BaseConfigModeExecutor(T arguments) {
        this(arguments, null);
    }

    public BaseConfigModeExecutor(T arguments, BuildSessionServiceProxy buildSessionIdProxy) {
        super(arguments);
        this.buildSessionIdProxy = buildSessionIdProxy;
    }

    @Override
    public boolean execute() {
        if (!this.getTokenData().isValid()) {
            return false;
        }
        if (!this.initBuildSessionServiceProxy()) {
            return false;
        }
        String buildSessionId = this.createBuildSessionId();
        return !StringUtils.isNullOrEmpty(buildSessionId);
    }

    protected boolean initBuildSessionServiceProxy() {
        if (this.buildSessionIdProxy == null) {
            if (((BaseConfigModeArguments)this.getArguments()).getToken() == null && this.getTokenData().getServer() == null) {
                LOG.warn("Invalid token, cannot execute");
                return false;
            }
            this.buildSessionIdProxy = new BuildSessionServiceProxyHandler(((BaseConfigModeArguments)this.getArguments()).getToken(), this.getTokenData().getServer(), ((BaseConfigModeArguments)this.getArguments()).getProxy());
        }
        return true;
    }

    public String getBuildSessionFilePath() {
        String overridePath = ((BaseConfigModeArguments)this.getArguments()).getBuildSessionIdFile();
        if (!StringUtils.isNullOrEmpty(overridePath)) {
            return this.tryResolveOverridePathToBuildSessionID(overridePath);
        }
        return BuildSessionIdFile.DEFAULT_PATH;
    }

    private String tryResolveOverridePathToBuildSessionID(String overridePath) {
        File overridePathFile = new File(overridePath);
        FileAndFolderUtils.verifyParentsExist(overridePathFile);
        if (overridePathFile.isDirectory()) {
            return BuildSessionIdFile.DEFAULT_PATH;
        }
        return overridePath;
    }

    protected abstract String createBuildSessionId();

    @Generated
    public BuildSessionServiceProxy getBuildSessionIdProxy() {
        return this.buildSessionIdProxy;
    }
}

