/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.components;

import io.sealights.onpremise.agents.buildscanner.execmode.components.ComponentsRequest;
import io.sealights.onpremise.agents.buildscanner.execmode.components.ComponentsServiceProxy;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClientFactory;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.api.SLServiceProxy;
import io.sealights.onpremise.agents.infra.http.client.HttpExceptions;
import io.sealights.onpremise.agents.infra.urlbuilder.UrlBuilder;

public class ComponentsServiceProxyHandler
extends SLServiceProxy
implements ComponentsServiceProxy {
    public static final String INTEGRATION_BUILDS = "integration-builds";
    public static final String COMPONENTS = "components";
    private static final String DATA_REJECTED_FMT = "Component data was rejected by server with code:%s, response:%s";

    public ComponentsServiceProxyHandler(String token, String server, String proxyConfig) {
        super(token, server, proxyConfig);
        this.setHttpClient(SLHttpClientFactory.getSLApacheHttpClient(token, this.getProxyInfo()));
    }

    @Override
    public boolean updateComponents(String bsId, ComponentsRequest request) {
        return this.sendComponentRequest(bsId, request, new SendMethod(){

            @Override
            public SLHttpResult<Void> run(String url, ComponentsRequest request) {
                return ComponentsServiceProxyHandler.this.getHttpClient().sendPutRequest(ComponentsServiceProxyHandler.this.createSLHttpRequest(url, request));
            }
        });
    }

    @Override
    public boolean deleteComponents(String bsId, ComponentsRequest request) {
        return this.sendComponentRequest(bsId, request, new SendMethod(){

            @Override
            public SLHttpResult<Void> run(String url, ComponentsRequest request) {
                return ComponentsServiceProxyHandler.this.getHttpClient().sendDeleteRequest(ComponentsServiceProxyHandler.this.createSLHttpRequest(url, request));
            }
        });
    }

    protected boolean sendComponentRequest(String bsId, ComponentsRequest request, SendMethod sendMethod) {
        try {
            String url = this.buildUrl(bsId);
            SLHttpResult<Void> slResult = sendMethod.run(url, request);
            if (slResult.isStatusCodeOk()) {
                return true;
            }
            return this.handleErrorResult(slResult);
        }
        catch (HttpExceptions.SLHttpException e) {
            return this.handleErrorResult(e.getResult());
        }
    }

    protected boolean handleErrorResult(SLHttpResult<?> slResult) {
        this.logConsoleError(String.format(DATA_REJECTED_FMT, slResult.getStatusCode(), slResult.getStatusMessage()));
        return false;
    }

    private String buildUrl(String bsId) {
        return new UrlBuilder().withHost(this.getServer()).withPath("v1", "agents", INTEGRATION_BUILDS, bsId, COMPONENTS).build();
    }

    private SLHttpRequest<Void> createSLHttpRequest(String url, ComponentsRequest request) {
        return new SLHttpRequest<Void>(this.getTag(), url, request, Void.class);
    }

    @Override
    public String getTag() {
        return "CMPS";
    }

    static interface SendMethod {
        public SLHttpResult<Void> run(String var1, ComponentsRequest var2);
    }
}

