/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode.components;

import io.sealights.onpremise.agents.buildscanner.execmode.BuildModeExecutor;
import io.sealights.onpremise.agents.buildscanner.execmode.components.ComponentsRequest;
import io.sealights.onpremise.agents.buildscanner.execmode.components.ComponentsServiceProxy;
import io.sealights.onpremise.agents.buildscanner.execmode.components.ComponentsServiceProxyHandler;
import io.sealights.onpremise.agents.buildscanner.integbuild.component.Component;
import io.sealights.onpremise.agents.buildscanner.integbuild.component.ComponentsInputHandler;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ComponentModeArguments;
import io.sealights.onpremise.agents.infra.configuration.validation.ValidationResult;
import io.sealights.onpremise.agents.infra.env.AgentId;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;

public class ComponentsModeExecutor
extends BuildModeExecutor<ComponentModeArguments> {
    private static Logger LOG = LogFactory.getLogger(ComponentsModeExecutor.class);
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static final String INVALID_DEPS_INPUT_CANNOT_SCAN = "Cannot update/delete component due to invalid depencdencies input, ";
    private ComponentsServiceProxy componentServiceProxy;

    public ComponentsModeExecutor(ComponentModeArguments arguments) {
        super(arguments);
    }

    @Override
    protected boolean doExecute() {
        ComponentsInputHandler componentInputHandler = new ComponentsInputHandler(((ComponentModeArguments)this.getArguments()).getComponentArguments(), true);
        ValidationResult validationResult = componentInputHandler.processAndValidate();
        if (!validationResult.isValid()) {
            return this.handleInputValidationErrors(validationResult);
        }
        boolean sendResult = this.sendRequest(componentInputHandler.getComponents());
        return this.handleSendResult(sendResult);
    }

    protected boolean sendRequest(List<Component> components) {
        this.initComponentsServiceProxy();
        switch (((ComponentModeArguments)this.getArguments()).getExecMode()) {
            case COMPONENT_UPDATE: {
                return this.componentServiceProxy.updateComponents(this.getBuildSessionData().getBuildSessionId(), this.createComponentsRequest(components));
            }
            case COMPONENT_DELETE: {
                return this.componentServiceProxy.deleteComponents(this.getBuildSessionData().getBuildSessionId(), this.createComponentsRequest(components));
            }
        }
        return false;
    }

    private void initComponentsServiceProxy() {
        if (this.componentServiceProxy == null) {
            this.componentServiceProxy = new ComponentsServiceProxyHandler(((ComponentModeArguments)this.getArguments()).getToken(), this.getTokenData().getServer(), ((ComponentModeArguments)this.getArguments()).getProxy());
        }
    }

    private ComponentsRequest createComponentsRequest(List<Component> components) {
        return new ComponentsRequest(AgentId.getAgentId(), components);
    }

    protected boolean handleInputValidationErrors(ValidationResult invalidResult) {
        String error = INVALID_DEPS_INPUT_CANNOT_SCAN + invalidResult.toStringErrors();
        CONSOLE_LOG.status(error);
        LOG.error(error);
        return false;
    }

    protected boolean handleSendResult(boolean sendResult) {
        if (sendResult) {
            CONSOLE_LOG.info("{} was executed successfully", (Object)((ComponentModeArguments)this.getArguments()).getExecMode());
        } else {
            String error = String.format("%s failed", new Object[]{((ComponentModeArguments)this.getArguments()).getExecMode()});
            CONSOLE_LOG.error(error);
            LOG.error(error);
        }
        return sendResult;
    }

    @Generated
    public ComponentsServiceProxy getComponentServiceProxy() {
        return this.componentServiceProxy;
    }

    @Generated
    public void setComponentServiceProxy(ComponentsServiceProxy componentServiceProxy) {
        this.componentServiceProxy = componentServiceProxy;
    }
}

