/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode;

import io.sealights.onpremise.agents.buildscanner.main.cli.ExecModeArguments;
import io.sealights.onpremise.agents.commons.defaultfiles.DefaultFileResolver;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.token.TokenData;
import io.sealights.onpremise.agents.infra.token.TokenParser;
import io.sealights.onpremise.agents.infra.utils.ArgumentFileReader;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import lombok.Generated;

public abstract class ModeExecutor<T extends ExecModeArguments> {
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private TokenData tokenData;
    private T arguments;

    protected ModeExecutor(T arguments) {
        this.arguments = arguments;
    }

    public TokenData searchAndExtractTokenData(ExecModeArguments args) {
        if (StringUtils.isNullOrEmpty(args.getToken()) && StringUtils.isNullOrEmpty(args.getTokenFile())) {
            this.trySetDefaultToken(args);
        }
        String rawToken = ArgumentFileReader.resolve(args.getToken(), args.getTokenFile());
        if (StringUtils.isNullOrEmpty(args.getToken())) {
            args.setToken(rawToken);
        }
        this.tokenData = TokenParser.parseAndValidate(rawToken);
        if (!this.tokenData.isValid()) {
            this.printTokenErrors(this.tokenData);
        }
        return this.tokenData;
    }

    public void trySetDefaultToken(ExecModeArguments args) {
        if (!StringUtils.isNullOrEmpty(System.getProperty("sl.token"))) {
            args.setToken(System.getProperty("sl.token"));
            CONSOLE_LOG.info("Using token from system property");
        }
        if (StringUtils.isNullOrEmpty(args.getTokenFile())) {
            String defaultTokenFile = new DefaultFileResolver().resolveToken(null);
            args.setTokenFile(defaultTokenFile);
        }
    }

    public void printTokenErrors(TokenData tokenData) {
        CONSOLE_LOG.error("Invalid token: {}", (Object)tokenData.toStringErrors());
    }

    public abstract boolean execute();

    public boolean isTokenRelevant() {
        return true;
    }

    @Generated
    public TokenData getTokenData() {
        return this.tokenData;
    }

    @Generated
    public T getArguments() {
        return this.arguments;
    }

    @Generated
    public void setTokenData(TokenData tokenData) {
        this.tokenData = tokenData;
    }

    @Generated
    public void setArguments(T arguments) {
        this.arguments = arguments;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModeExecutor)) {
            return false;
        }
        ModeExecutor other = (ModeExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TokenData this$tokenData = this.getTokenData();
        TokenData other$tokenData = other.getTokenData();
        if (this$tokenData == null ? other$tokenData != null : !((Object)this$tokenData).equals(other$tokenData)) {
            return false;
        }
        T this$arguments = this.getArguments();
        T other$arguments = other.getArguments();
        return !(this$arguments == null ? other$arguments != null : !this$arguments.equals(other$arguments));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ModeExecutor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TokenData $tokenData = this.getTokenData();
        result = result * 59 + ($tokenData == null ? 43 : ((Object)$tokenData).hashCode());
        T $arguments = this.getArguments();
        result = result * 59 + ($arguments == null ? 43 : $arguments.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "ModeExecutor(tokenData=" + this.getTokenData() + ", arguments=" + this.getArguments() + ")";
    }

    @Generated
    public ModeExecutor() {
    }
}

