/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode;

import io.sealights.onpremise.agents.buildscanner.main.cli.ModesOptions;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.infra.filters.IncludeExcludeFilter;

public class IncludeExcludeFilterFactory {
    public static final String DEPENDENCIES_EXCLUDES = "*.dependencies.*";

    public static IncludeExcludeFilter createFilesFilter(ScanModeArguments arguments) {
        IncludeExcludeFilter filesFilter;
        if (arguments.getExecMode().equals((Object)ModesOptions.ExecMode.SCAN)) {
            String filesIncluded = arguments.getFilesIncluded();
            String filesExcluded = arguments.getFilesExcluded();
            filesFilter = new IncludeExcludeFilter(filesIncluded, filesExcluded);
        } else {
            filesFilter = new IncludeExcludeFilter("*.jar,*.war,*.ear,*.class", "*.git*");
        }
        return filesFilter;
    }

    public static IncludeExcludeFilter createPackagesFilter(ScanModeArguments arguments) {
        IncludeExcludeFilter packagesFilter;
        if (arguments.getExecMode().equals((Object)ModesOptions.ExecMode.SCAN)) {
            String filesIncluded = arguments.getPackagesIncluded();
            String filesExcluded = arguments.getPackagesExcluded();
            packagesFilter = new IncludeExcludeFilter(filesIncluded, filesExcluded);
        } else {
            packagesFilter = IncludeExcludeFilterFactory.createDependenciesFilter();
        }
        return packagesFilter;
    }

    public static IncludeExcludeFilter createDependenciesFilter() {
        return new IncludeExcludeFilter(null, DEPENDENCIES_EXCLUDES);
    }
}

