/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.execmode;

import io.sealights.onpremise.agents.buildscanner.execmode.ModeExecutor;
import io.sealights.onpremise.agents.buildscanner.execmode.buildend.BuildModeAgentDescriptorCreator;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.BaseBuildModeArguments;
import io.sealights.onpremise.agents.buildscanner.main.inputvalidator.BuildModeArgumentsValidator;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import io.sealights.onpremise.agents.infra.configuration.SLAgentConfiguration;
import io.sealights.onpremise.agents.infra.configuration.stringable.StringableConfiguration;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionServiceProxy;
import io.sealights.onpremise.agents.infra.serviceproxy.buildsession.BuildSessionServiceProxyHandler;
import io.sealights.onpremise.agents.infra.types.BuildSessionData;
import lombok.Generated;

public abstract class BuildModeExecutor<T extends BaseBuildModeArguments>
extends ModeExecutor<T> {
    private BuildSessionData buildSessionData;
    private BuildModeArgumentsValidator argsValidator;
    private BuildSessionServiceProxy buildSessionIdProxy;

    protected BuildModeExecutor(T arguments) {
        super(arguments);
        this.argsValidator = new BuildModeArgumentsValidator((BaseBuildModeArguments)arguments);
    }

    @Override
    public boolean execute() {
        if (this.initBuildSessionId()) {
            AgentLifeCycle.notifyStart(new BuildModeAgentDescriptorCreator(this.getBuildSessionData()), new SimpleConfiguration((BaseBuildModeArguments)this.getArguments(), this.getTokenData().getServer()));
            return this.doExecute();
        }
        return false;
    }

    protected boolean initBuildSessionId() {
        if (this.argsValidator.validate()) {
            this.getBuildSessionDataFromServer();
            return this.buildSessionData != null;
        }
        return false;
    }

    protected void getBuildSessionDataFromServer() {
        if (this.buildSessionIdProxy == null) {
            this.buildSessionIdProxy = new BuildSessionServiceProxyHandler(((BaseBuildModeArguments)this.getArguments()).getToken(), this.getTokenData().getServer(), ((BaseBuildModeArguments)this.getArguments()).getProxy());
        }
        this.buildSessionData = this.buildSessionIdProxy.getBuildSessionData(((BaseBuildModeArguments)this.getArguments()).getBuildSessionId());
    }

    protected abstract boolean doExecute();

    @Generated
    public BuildSessionData getBuildSessionData() {
        return this.buildSessionData;
    }

    @Generated
    public BuildModeArgumentsValidator getArgsValidator() {
        return this.argsValidator;
    }

    @Generated
    public BuildSessionServiceProxy getBuildSessionIdProxy() {
        return this.buildSessionIdProxy;
    }

    @Generated
    public void setBuildSessionData(BuildSessionData buildSessionData) {
        this.buildSessionData = buildSessionData;
    }

    @Generated
    public void setArgsValidator(BuildModeArgumentsValidator argsValidator) {
        this.argsValidator = argsValidator;
    }

    @Generated
    public void setBuildSessionIdProxy(BuildSessionServiceProxy buildSessionIdProxy) {
        this.buildSessionIdProxy = buildSessionIdProxy;
    }

    @Override
    @Generated
    public String toString() {
        return "BuildModeExecutor(buildSessionData=" + this.getBuildSessionData() + ", argsValidator=" + this.getArgsValidator() + ", buildSessionIdProxy=" + this.getBuildSessionIdProxy() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildModeExecutor)) {
            return false;
        }
        BuildModeExecutor other = (BuildModeExecutor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuildSessionData this$buildSessionData = this.getBuildSessionData();
        BuildSessionData other$buildSessionData = other.getBuildSessionData();
        if (this$buildSessionData == null ? other$buildSessionData != null : !((Object)this$buildSessionData).equals(other$buildSessionData)) {
            return false;
        }
        BuildModeArgumentsValidator this$argsValidator = this.getArgsValidator();
        BuildModeArgumentsValidator other$argsValidator = other.getArgsValidator();
        if (this$argsValidator == null ? other$argsValidator != null : !this$argsValidator.equals(other$argsValidator)) {
            return false;
        }
        BuildSessionServiceProxy this$buildSessionIdProxy = this.getBuildSessionIdProxy();
        BuildSessionServiceProxy other$buildSessionIdProxy = other.getBuildSessionIdProxy();
        return !(this$buildSessionIdProxy == null ? other$buildSessionIdProxy != null : !this$buildSessionIdProxy.equals(other$buildSessionIdProxy));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BuildModeExecutor;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        BuildSessionData $buildSessionData = this.getBuildSessionData();
        result = result * 59 + ($buildSessionData == null ? 43 : ((Object)$buildSessionData).hashCode());
        BuildModeArgumentsValidator $argsValidator = this.getArgsValidator();
        result = result * 59 + ($argsValidator == null ? 43 : $argsValidator.hashCode());
        BuildSessionServiceProxy $buildSessionIdProxy = this.getBuildSessionIdProxy();
        result = result * 59 + ($buildSessionIdProxy == null ? 43 : $buildSessionIdProxy.hashCode());
        return result;
    }

    public static class SimpleConfiguration
    extends SLAgentConfiguration {
        private BaseBuildModeArguments arguments;
        private String server;

        public SimpleConfiguration(BaseBuildModeArguments arguments, String server) {
            this.arguments = arguments;
            this.server = server;
        }

        @Override
        public String getToken() {
            return this.arguments.getToken();
        }

        @Override
        public String getBuildSessionId() {
            return this.arguments.getBuildSessionId();
        }

        @Override
        public String getServer() {
            return this.server;
        }

        @Override
        public String getProxy() {
            return this.arguments.getProxy();
        }

        @Override
        public StringableConfiguration.PropConvertList createPropConverters() {
            return null;
        }
    }
}

