/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.api;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.api.HashedClassData;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration.ScanConfigurationInfo;
import io.sealights.onpremise.agents.buildscanner.integbuild.component.Component;
import io.sealights.onpremise.agents.infra.utils.ToStringFormatter;
import java.util.List;
import java.util.Map;
import lombok.Generated;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BuildMappingRequest {
    private Map<String, Object> meta;
    private ScanConfigurationInfo configurationInfo;
    private List<? extends HashedClassData> files;
    private List<Component> dependencies;

    public BuildMappingRequest(Map<String, Object> meta, ScanConfigurationInfo configurationInfo, List<? extends HashedClassData> files, List<Component> dependencies) {
        this.meta = meta;
        this.configurationInfo = configurationInfo;
        this.files = files;
        this.dependencies = dependencies;
    }

    public int getNumOfReportedMethods() {
        int counter = 0;
        for (HashedClassData hashedClassData : this.getFiles()) {
            counter += hashedClassData.getMethods().size();
        }
        return counter;
    }

    public int getNumOfReportedFiles() {
        return this.getFiles().size();
    }

    public String toString() {
        String EOL2 = "\n";
        StringBuilder builder = new StringBuilder();
        builder.append("BuildMappingRequest: (see metaData in the log above...)").append("\n");
        builder.append(this.configurationInfo).append("\n");
        builder.append("Files mapping:").append(ToStringFormatter.toString(this.files));
        builder.append("Dependencies:").append(ToStringFormatter.toString(this.dependencies));
        return builder.toString();
    }

    @Generated
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @Generated
    public ScanConfigurationInfo getConfigurationInfo() {
        return this.configurationInfo;
    }

    @Generated
    public List<? extends HashedClassData> getFiles() {
        return this.files;
    }

    @Generated
    public List<Component> getDependencies() {
        return this.dependencies;
    }

    @Generated
    public void setMeta(Map<String, Object> meta) {
        this.meta = meta;
    }

    @Generated
    public void setConfigurationInfo(ScanConfigurationInfo configurationInfo) {
        this.configurationInfo = configurationInfo;
    }

    @Generated
    public void setFiles(List<? extends HashedClassData> files) {
        this.files = files;
    }

    @Generated
    public void setDependencies(List<Component> dependencies) {
        this.dependencies = dependencies;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BuildMappingRequest)) {
            return false;
        }
        BuildMappingRequest other = (BuildMappingRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$meta = this.getMeta();
        Map<String, Object> other$meta = other.getMeta();
        if (this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta)) {
            return false;
        }
        ScanConfigurationInfo this$configurationInfo = this.getConfigurationInfo();
        ScanConfigurationInfo other$configurationInfo = other.getConfigurationInfo();
        if (this$configurationInfo == null ? other$configurationInfo != null : !((Object)this$configurationInfo).equals(other$configurationInfo)) {
            return false;
        }
        List<? extends HashedClassData> this$files = this.getFiles();
        List<? extends HashedClassData> other$files = other.getFiles();
        if (this$files == null ? other$files != null : !((Object)this$files).equals(other$files)) {
            return false;
        }
        List<Component> this$dependencies = this.getDependencies();
        List<Component> other$dependencies = other.getDependencies();
        return !(this$dependencies == null ? other$dependencies != null : !((Object)this$dependencies).equals(other$dependencies));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BuildMappingRequest;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        ScanConfigurationInfo $configurationInfo = this.getConfigurationInfo();
        result = result * 59 + ($configurationInfo == null ? 43 : ((Object)$configurationInfo).hashCode());
        List<? extends HashedClassData> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        List<Component> $dependencies = this.getDependencies();
        result = result * 59 + ($dependencies == null ? 43 : ((Object)$dependencies).hashCode());
        return result;
    }

    @Generated
    private BuildMappingRequest() {
    }
}

