/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy;

import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.AnonymousMethodsIdsBuilder;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.ClosureMethodsIdsBuilder;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.api.HashedMethodData;
import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.commons.instrument.utils.MethodNamingHelper;
import java.util.ArrayList;
import java.util.List;

public class MethodMappingBuilder {
    private List<MethodSignature> allMethods;
    private List<MethodSignature> simpleMethods = new ArrayList<MethodSignature>();
    private List<MethodSignature> anonymousMethods = new ArrayList<MethodSignature>();
    private List<MethodSignature> closureMethods = new ArrayList<MethodSignature>();
    List<HashedMethodData> hashedMethodData = new ArrayList<HashedMethodData>();

    public MethodMappingBuilder(List<MethodSignature> allMethods) {
        this.allMethods = allMethods;
    }

    public List<HashedMethodData> build() {
        if (this.allMethods == null) {
            return this.hashedMethodData;
        }
        this.splitMethods();
        this.buildSimpleMethods();
        this.buildAnonymousMethods();
        this.buildClosureMethods();
        return this.hashedMethodData;
    }

    private void splitMethods() {
        for (MethodSignature methodSignature : this.allMethods) {
            if (methodSignature.getClassification().isGroovyClosure()) {
                this.closureMethods.add(methodSignature);
                continue;
            }
            if (methodSignature.isAnonymous()) {
                this.anonymousMethods.add(methodSignature);
                continue;
            }
            this.simpleMethods.add(methodSignature);
        }
    }

    private void buildSimpleMethods() {
        for (MethodSignature simpleMethod : this.simpleMethods) {
            this.hashedMethodData.add(this.buildMethodData(simpleMethod));
        }
    }

    private void buildAnonymousMethods() {
        if (this.anonymousMethods.isEmpty()) {
            return;
        }
        List<MethodSignature> anonymousSignature = new AnonymousMethodsIdsBuilder().build(this.anonymousMethods);
        for (MethodSignature aSig : anonymousSignature) {
            this.hashedMethodData.add(this.buildMethodData(aSig));
        }
    }

    private void buildClosureMethods() {
        if (this.closureMethods.isEmpty()) {
            return;
        }
        List<MethodSignature> anonymousSignature = new ClosureMethodsIdsBuilder().build(this.closureMethods);
        for (MethodSignature aSig : anonymousSignature) {
            this.hashedMethodData.add(this.buildMethodData(aSig));
        }
    }

    private HashedMethodData buildMethodData(MethodSignature mSig) {
        String uniqueId = mSig.getUniqueId();
        String displayName = MethodNamingHelper.buildDisplayNameForBuildMapping(mSig);
        String hash = mSig.getHash();
        Integer[] position = new Integer[]{mSig.getStartLineNumber(), mSig.getColumnNumber()};
        Integer[] endPosition = new Integer[2];
        endPosition[0] = mSig.getEndLineNumber();
        String elementId = mSig.getElementId();
        return new HashedMethodData(mSig.getIndex(), hash, uniqueId, elementId, displayName, position, endPosition, new HashedMethodData.TechnologySpecificInfo(mSig), new HashedMethodData.MethodMetaData(mSig.isAnonymous()));
    }
}

