/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy;

import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.buildscanner.scm.utils.ToStringFormatter;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import io.sealights.onpremise.agents.infra.env.AgentId;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;

public class MetaDataBuilder {
    private static Logger LOG = LogFactory.getLogger(MetaDataBuilder.class);
    public static final String JAVA = "java";
    private static final int HASH_VERSION = 2;
    private ScanModeArguments scanArguments;
    private Map<String, Object> metaData;

    public MetaDataBuilder(ScanModeArguments scanArguments) {
        this.scanArguments = scanArguments;
        this.metaData = new HashMap<String, Object>();
    }

    public Map<String, Object> build() {
        this.putBuildInfo();
        this.readAndAppendMetadataJsonFile();
        LOG.info("created meta data:\n{}", (Object)ToStringFormatter.MetaDataFormatter.toStringMetaDataCompact(this.metaData));
        return this.metaData;
    }

    private void readAndAppendMetadataJsonFile() {
        try {
            String pathToMetaJson = this.scanArguments.getPathToMetaJson();
            if (!StringUtils.isNullOrEmpty(pathToMetaJson)) {
                File jsonFile = new File(pathToMetaJson);
                Map additionalMetadata = (Map)JsonObjectMapper.toObject(jsonFile, this.metaData.getClass());
                this.metaData.putAll(additionalMetadata);
            }
        }
        catch (Exception e) {
            AgentLifeCycle.notifyException(this.getClass(), "Unable to append data from the 'metadata.json' file.", e);
        }
    }

    private void putBuildInfo() {
        this.metaData.put("appName", this.scanArguments.getAppname());
        this.metaData.put("agentId", AgentId.getAgentId());
        this.metaData.put("branch", this.scanArguments.getBranch());
        this.metaData.put("build", this.scanArguments.getBuild());
        this.metaData.put("buildScannerVersion", MetaDataBuilder.class.getPackage().getImplementationVersion());
        this.metaData.put("generated", System.currentTimeMillis());
        this.metaData.put("uniqueModuleId", this.scanArguments.getModuleName());
        this.metaData.put("buildSessionId", this.scanArguments.getBuildSessionId());
        this.metaData.put("methodHashAlgorithm", this.createMethodHashAlgorithm());
        this.metaData.put("scanArguments", this.scanArguments);
        this.metaData.put("technology", JAVA);
    }

    private String createMethodHashAlgorithm() {
        return String.format("java%s:sealights%s", System.getProperty("java.specification.version"), 2);
    }
}

