/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy;

import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.MethodMappingBuilder;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.api.HashedClassData;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.api.HashedLineData;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.api.HashedMethodData;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.FileErrorsContainer;
import io.sealights.onpremise.agents.commons.instrument.types.ClassSignature;
import io.sealights.onpremise.agents.commons.instrument.types.LineSignature;
import io.sealights.onpremise.agents.infra.logging.Level;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.logging.LogLevelToStringFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;

public class ClassMappingBuilder {
    private static Logger LOG = LogFactory.getLogger(ClassMappingBuilder.class);
    public static final String MAPPING_FAILURES = "Build mapping failures: ";
    private int globalMethodsCtr = 0;
    private List<HashedClassData> classesMapping = new ArrayList<HashedClassData>();
    private FileErrorsContainer errorsContainer = new FileErrorsContainer();

    public static Set<Integer> collectMethodIndices(List<HashedMethodData> methods) {
        HashSet<Integer> methodsIndices = new HashSet<Integer>();
        for (HashedMethodData methodData : methods) {
            methodsIndices.add(methodData.getMethodIndex());
        }
        return methodsIndices;
    }

    public List<HashedClassData> build(Map<String, ClassSignature> allFiles) {
        for (ClassSignature cSig : allFiles.values()) {
            if (cSig == null) continue;
            if (cSig.isTestClass()) {
                LOG.debug("Skipped mapping of test class '{}'", (Object)cSig.getClassName());
                continue;
            }
            this.buildClassData(cSig);
        }
        this.notifyMappingResults();
        return this.classesMapping;
    }

    private void buildClassData(ClassSignature signature) {
        try {
            HashedClassData classData2 = new HashedClassData(signature);
            String className = signature.getClassName();
            String classPackageName = signature.getClassPackage();
            List<HashedMethodData> methods = new MethodMappingBuilder(signature.getMethods()).build();
            Set<Integer> methodIndices = ClassMappingBuilder.collectMethodIndices(methods);
            List<HashedLineData> lines = this.toLineData(signature.getLines(), className, classPackageName, methodIndices);
            classData2.setMethods(methods);
            classData2.setLines(lines);
            this.setGlobalMethodsIndices(classData2);
            this.classesMapping.add(classData2);
        }
        catch (Throwable e) {
            this.errorsContainer.addFileError(signature.getClassName(), signature.getSourceFile(), e);
            LOG.error("Failed to map signature of class '{}' (file: '{}')", signature.getClassName(), signature.getRelativePath(), e);
        }
    }

    private void setGlobalMethodsIndices(HashedClassData classData2) {
        HashMap<Integer, Integer> old2NewIndex = new HashMap<Integer, Integer>();
        for (HashedMethodData methodData : classData2.getMethods()) {
            old2NewIndex.put(methodData.getMethodIndex(), this.globalMethodsCtr);
            methodData.setMethodIndex(this.globalMethodsCtr++);
        }
        for (HashedLineData lineData : classData2.getLines()) {
            lineData.setMethodIndex((Integer)old2NewIndex.get(lineData.getMethodIndex()));
        }
    }

    private List<HashedLineData> toLineData(List<LineSignature> lines, String fileName, String packageName, Set<Integer> methodIndices) {
        ArrayList<HashedLineData> results = new ArrayList<HashedLineData>();
        for (LineSignature lineSignature : lines) {
            if (!methodIndices.contains(lineSignature.getMethodIndex())) continue;
            HashedLineData ld = new HashedLineData(lineSignature, fileName);
            results.add(ld);
        }
        return results;
    }

    private void notifyMappingResults() {
        this.errorsContainer.notifyErrors(MAPPING_FAILURES);
        LOG.debug("Created classes mapping:{}", (Object)LogLevelToStringFormatter.toString(Level.DEBUG, this.classesMapping));
    }

    @Generated
    public FileErrorsContainer getErrorsContainer() {
        return this.errorsContainer;
    }
}

