/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy;

import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEventCode;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.BuildMappingRequestBuilder;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.BuildScanData;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.api.BuildMappingRequest;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.api.BuildMappingServiceProxy;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration.ScanConfigurationInfo;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.commons.lifecycle.events.AgentLifeCycle;
import io.sealights.onpremise.agents.infra.git.controller.GitController;
import io.sealights.onpremise.agents.infra.http.api.SLHttpClient;
import io.sealights.onpremise.agents.infra.http.api.SLHttpRequest;
import io.sealights.onpremise.agents.infra.http.api.SLHttpResult;
import io.sealights.onpremise.agents.infra.http.api.SLServiceProxy;
import io.sealights.onpremise.agents.infra.logging.ConsoleLogger;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.urlbuilder.UrlBuilder;
import org.slf4j.Logger;

public class BuildMappingServiceProxyHandler
extends SLServiceProxy
implements BuildMappingServiceProxy {
    private static ConsoleLogger CONSOLE_LOG = LogFactory.createConsoleLogger();
    private static Logger LOG = LogFactory.getLogger(BuildMappingServiceProxyHandler.class);
    private static final String BUILD_MAPPING = "buildmapping";
    private static final String FAILURE_MSG_FMT = "Failed to send build data to the server for module:'%s'; error:[%s]; %s";
    private static final String DATA_REJECTED_MSG_FMT = "Build-mapping of module '%s' was rejected by the server, error:[%s]";
    private static final String DATA_SENT_MSG_FMT = "Build-mapping for module '%s' was sent - %s";
    private static final String MAPPING_ALREADY_EXISTS = " - build-mapping for current app-branch-build combo already exists";
    private ScanModeArguments scanArguments;
    private ScanConfigurationInfo configuration;
    private GitController gitController;

    public BuildMappingServiceProxyHandler(ScanModeArguments scanArguments, ScanConfigurationInfo configuration, GitController gitController) {
        super(configuration.getToken(), configuration.getServer(), configuration.getProxy(), configuration.isCompressRequest());
        this.scanArguments = scanArguments;
        this.configuration = configuration;
        this.gitController = gitController;
    }

    @Override
    public boolean sendBuildScanData(BuildScanData buildScanData) {
        BuildMappingRequest mappingRequest = this.createBuildMappingRequest(this.configuration, buildScanData);
        String scanResults = String.format("scanned %s methods in %s files", mappingRequest.getNumOfReportedMethods(), mappingRequest.getNumOfReportedFiles());
        try {
            SLHttpResult<Void> slResult = this.doPost(mappingRequest);
            if (slResult.isStatusCodeOk()) {
                this.notifySuccess(scanResults);
                return true;
            }
            if (slResult.getStatusCode() == 409) {
                this.notifyDataReject(slResult.getStatusMessage());
                return true;
            }
            this.notifySubmitError(slResult.getStatusMessage(), scanResults);
            return false;
        }
        catch (Throwable e) {
            this.notifySubmitError(e.getMessage(), scanResults);
            return false;
        }
    }

    private BuildMappingRequest createBuildMappingRequest(ScanConfigurationInfo configurationInfo, BuildScanData buildScanData) {
        BuildMappingRequestBuilder builder = BuildMappingRequestBuilder.createBuilder(this.scanArguments, buildScanData, configurationInfo, this.gitController);
        return builder.build();
    }

    private SLHttpResult<Void> doPost(BuildMappingRequest request) {
        SLHttpResult<Void> slResult = this.getHttpClient().sendRequestRetry(new SLHttpRequest<Void>(this.getTag(), this.buildUrl(), request, Void.class), new SLHttpClient.RequestRetry<Void>(){

            @Override
            public SLHttpResult<Void> execute(SLHttpRequest<Void> slRequest) {
                return BuildMappingServiceProxyHandler.this.getHttpClient().sendPostRequest(slRequest);
            }

            @Override
            public boolean isRecoverableError(int httpCode) {
                if (409 == httpCode || 400 == httpCode) {
                    return false;
                }
                return super.isRecoverableError(httpCode);
            }
        });
        return slResult;
    }

    private String buildUrl() {
        return new UrlBuilder().withHost(this.getServer()).withPath("v5", "agents", BUILD_MAPPING).build();
    }

    private void notifySuccess(String scanResults) {
        String msg = String.format(DATA_SENT_MSG_FMT, this.scanArguments.getModuleName(), scanResults);
        CONSOLE_LOG.status(msg);
        LOG.info(msg);
        AgentLifeCycle.notifyInfoMsg(msg);
    }

    private void notifyDataReject(String statusMessage) {
        String warning = String.format(DATA_REJECTED_MSG_FMT, this.scanArguments.getModuleName(), statusMessage + MAPPING_ALREADY_EXISTS);
        CONSOLE_LOG.status(warning);
        LOG.warn(warning);
    }

    private void notifySubmitError(String reason, String scanResults) {
        String errorMsg = String.format(FAILURE_MSG_FMT, this.scanArguments.getModuleName(), reason, scanResults);
        AgentLifeCycle.notifyMsgEvent(AgentEventCode.BUILD_MAP_SUBMISSION_ERROR, errorMsg);
        CONSOLE_LOG.status(errorMsg);
    }

    @Override
    public String getTag() {
        return "BMS";
    }
}

