/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy;

import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.BuildScanData;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.ClassMappingBuilder;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.MetaDataBuilder;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.api.BuildMappingRequest;
import io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy.api.HashedClassData;
import io.sealights.onpremise.agents.buildscanner.execmode.scan.configuration.ScanConfigurationInfo;
import io.sealights.onpremise.agents.buildscanner.main.cli.build.ScanModeArguments;
import io.sealights.onpremise.agents.infra.git.controller.GitController;
import io.sealights.onpremise.agents.infra.git.utils.GitFilesLookup;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class BuildMappingRequestBuilder {
    private static Logger LOG = LogFactory.getLogger(BuildMappingRequestBuilder.class);
    private ScanModeArguments scanArguments;
    private BuildScanData buildScanData;
    private ScanConfigurationInfo configurationInfo;
    private GitController gitController;
    private MetaDataBuilder metaDataBuilder;

    public static BuildMappingRequestBuilder createBuilder(ScanModeArguments scanArguments, BuildScanData buildScanData, ScanConfigurationInfo configurationInfo, GitController gitController) {
        return new BuildMappingRequestBuilder(scanArguments, buildScanData, configurationInfo, gitController);
    }

    protected BuildMappingRequestBuilder(ScanModeArguments scanArguments, BuildScanData buildScanData, ScanConfigurationInfo configurationInfo, GitController gitController) {
        this.scanArguments = scanArguments;
        this.buildScanData = buildScanData;
        this.configurationInfo = configurationInfo;
        this.metaDataBuilder = new MetaDataBuilder(scanArguments);
        this.gitController = gitController;
    }

    public BuildMappingRequest build() {
        ClassMappingBuilder mapper = new ClassMappingBuilder();
        List<HashedClassData> classMapping = mapper.build(this.buildScanData.getClassSignatures());
        if (!classMapping.isEmpty()) {
            this.updateFilesPhysicalPath(classMapping);
        }
        Map<String, Object> meta = this.metaDataBuilder.build();
        return new BuildMappingRequest(meta, this.configurationInfo, classMapping, this.scanArguments.getIntegBuildDependencies());
    }

    private void updateFilesPhysicalPath(List<HashedClassData> classMapping) {
        GitFilesLookup gitFilesLookup = this.gitController.collectFilesLookup();
        for (HashedClassData fileData : classMapping) {
            fileData.setPhysicalPath(this.resolveGitPath(gitFilesLookup, fileData, this.gitController.getCfg().getWorkspacePath()));
        }
    }

    private String resolveGitPath(GitFilesLookup gitFilesLookup, HashedClassData fileData, String workspace) {
        String filePath = gitFilesLookup.getMatchingFile(fileData.getPhysicalPath());
        if (filePath == null) {
            filePath = workspace + File.separator + fileData.getPhysicalPath();
            LOG.info("Scanned file '{}' not found in git; using path '{}'", (Object)fileData.getPhysicalPath(), (Object)filePath);
        }
        return filePath;
    }
}

