/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.buildmap.service.proxy;

import io.sealights.onpremise.agents.commons.instrument.types.MethodSignature;
import io.sealights.onpremise.agents.commons.instrument.utils.MethodNamingHelper;
import io.sealights.onpremise.agents.infra.utils.instrumentation.MethodNamingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AnonymousMethodsIdsBuilder {
    private Map<String, List<MethodSignature>> anonymousMethods = new HashMap<String, List<MethodSignature>>();

    public List<MethodSignature> build(List<MethodSignature> methodSignatures) {
        if (methodSignatures == null || methodSignatures.isEmpty()) {
            return null;
        }
        this.stripLambdaIndexAndCollectMethodsToMap(methodSignatures);
        ArrayList<MethodSignature> sigWithNewIds = new ArrayList<MethodSignature>();
        this.tailIndexToMethodElementIds(sigWithNewIds);
        return sigWithNewIds;
    }

    private void stripLambdaIndexAndCollectMethodsToMap(List<MethodSignature> methodSignatures) {
        for (MethodSignature currMethod : methodSignatures) {
            String newElementId = this.removeIndexFromElementId(currMethod);
            currMethod.setElementId(newElementId);
            if (this.anonymousMethods.containsKey(newElementId)) {
                this.anonymousMethods.get(currMethod.getElementId()).add(currMethod);
                continue;
            }
            ArrayList<MethodSignature> methods = new ArrayList<MethodSignature>();
            methods.add(currMethod);
            this.anonymousMethods.put(newElementId, methods);
        }
    }

    private void tailIndexToMethodElementIds(List<MethodSignature> sigWithNewIds) {
        for (String methodId : this.anonymousMethods.keySet()) {
            this.anonymousMethods.put(methodId, this.sortAndAppendIndexToId(this.anonymousMethods.get(methodId)));
            sigWithNewIds.addAll((Collection<MethodSignature>)this.anonymousMethods.get(methodId));
        }
    }

    private List<MethodSignature> sortAndAppendIndexToId(List<MethodSignature> methods) {
        Collections.sort(methods, new Comparator<MethodSignature>(){

            @Override
            public int compare(MethodSignature sig1, MethodSignature sig2) {
                if (sig1.getStartLineNumber() != null && sig2.getStartLineNumber() != null) {
                    return sig1.getStartLineNumber().compareTo(sig2.getStartLineNumber());
                }
                return 0;
            }
        });
        for (int i = 0; i < methods.size(); ++i) {
            MethodSignature currMethod = methods.get(i);
            currMethod.setElementId(currMethod.getElementId() + "_" + i);
        }
        return methods;
    }

    protected String removeIndexFromElementId(MethodSignature methodSig) {
        String nameWithOutIndex = MethodNamingHelper.removeLambdaIndex(methodSig.getName());
        String classAndMethodName = methodSig.getClassName() + "." + nameWithOutIndex;
        String newElementId = MethodNamingUtils.getElementId(methodSig.getAccess(), classAndMethodName, methodSig.getDescriptor());
        return newElementId;
    }
}

