/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.bootstrap;

import io.sealights.onpremise.agents.buildscanner.main.cli.ExecModeArguments;
import io.sealights.onpremise.agents.infra.configuration.UpgradeConfiguration;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.token.TokenData;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import org.slf4j.Logger;

public final class UpgradeConfigurationBuilder {
    private static Logger LOG = LogFactory.getLogger(UpgradeConfigurationBuilder.class);
    private UpgradeConfiguration cfg;
    private ExecModeArguments modeArgs;
    private TokenData tokenData;

    public static UpgradeConfiguration createUpgradeConfiguration(ExecModeArguments modeArgs, TokenData tokenData) {
        UpgradeConfigurationBuilder instance = new UpgradeConfigurationBuilder(modeArgs, tokenData);
        instance.execute();
        return instance.cfg;
    }

    protected void execute() {
        this.modeArgs.mapArguments(this.cfg);
        this.applyTokenData();
        this.setFileStorage();
        this.cfg.setEnableUpgrade(true);
        LOG.debug("created " + this.cfg);
    }

    protected void applyTokenData() {
        this.cfg.setCustomerId(this.tokenData.getCustomerId());
        this.cfg.setServer(this.tokenData.getServer());
        this.cfg.setToken(this.modeArgs.getToken());
    }

    protected void setFileStorage() {
        String value = System.getProperty("sl.fileStorage");
        if (StringUtils.isNotEmpty(value)) {
            this.cfg.setFileStorage(value);
        }
    }

    private UpgradeConfigurationBuilder(ExecModeArguments modeArgs, TokenData tokenData) {
        this.modeArgs = modeArgs;
        this.tokenData = tokenData;
        this.cfg = new UpgradeConfiguration();
    }
}

