/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.bootstrap;

import io.sealights.onpremise.agents.infra.constants.SLProperties;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.utils.jvm.JvmUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class BuildAgentCliBuilder {
    public static final String AGENTLIB_PROPERTY = "-agentlib";
    public static final String JAR_ARG = "-jar";
    public static String[] FILE_NAMES_ARGS = new String[]{"-filesexcluded", "-fe", "-filesincluded", "-fi"};
    private static Logger LOG = LogFactory.getLogger(BuildAgentCliBuilder.class);
    private static final String[] JVM_ARGS_2_IGNORE = new String[]{"-agentlib", "-Dsl.enableUpgrade"};
    private List<String> destArgs = new ArrayList<String>();

    public List<String> execute(String[] appArgs, String jarPathName) {
        LOG.info("Prepare CLI for recommended jar execution...");
        this.destArgs.add(JvmUtils.resolveJavaPath());
        this.putJvmArguments();
        this.putUpgradeOff();
        this.putEnableNoZeroRetCode();
        this.destArgs.add(JAR_ARG);
        this.destArgs.add(jarPathName);
        this.putOriginalArgs(appArgs);
        LOG.info("CLI arguments:{}", (Object)this.destArgs);
        return this.destArgs;
    }

    private void putOriginalArgs(String[] appArgs) {
        boolean fileNameArg = false;
        for (String arg : appArgs) {
            if (arg.startsWith("-")) {
                this.destArgs.add(arg);
                fileNameArg = this.isFileNameArg(arg);
                continue;
            }
            if (fileNameArg && arg.startsWith("*")) {
                this.destArgs.add("\"" + arg + "\"");
            } else {
                this.destArgs.add(arg);
            }
            fileNameArg = false;
        }
    }

    private void putJvmArguments() {
        RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
        List<String> vmArgs = runtimeMxBean.getInputArguments();
        for (String arg : vmArgs) {
            if (this.isJvmArgToIgnore(arg)) continue;
            this.destArgs.add(arg);
        }
    }

    private void putUpgradeOff() {
        this.destArgs.add(SLProperties.toJvmAgr("sl.enableUpgrade", false));
    }

    private void putEnableNoZeroRetCode() {
        this.destArgs.add(SLProperties.toJvmAgr("sl.enableNoneZeroErrorCode", true));
    }

    private boolean isJvmArgToIgnore(String jvmArg) {
        for (int i = 0; i < JVM_ARGS_2_IGNORE.length; ++i) {
            if (!jvmArg.startsWith(JVM_ARGS_2_IGNORE[i])) continue;
            return true;
        }
        return false;
    }

    private boolean isFileNameArg(String arg) {
        for (String fa : FILE_NAMES_ARGS) {
            if (!arg.equals(fa)) continue;
            return true;
        }
        return false;
    }
}

