/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agents.buildscanner.bootstrap;

import io.sealights.onpremise.agents.buildscanner.bootstrap.BuildAgentCliBuilder;
import io.sealights.onpremise.agents.infra.configuration.PropertiesFileReader;
import io.sealights.onpremise.agents.infra.configuration.UpgradeConfiguration;
import io.sealights.onpremise.agents.infra.logging.LogFactory;
import io.sealights.onpremise.agents.infra.upgrade.BuildScannerUpgraderFactory;
import io.sealights.onpremise.agents.infra.upgrade.ComponentUpgrader;
import io.sealights.onpremise.agents.infra.utils.StringUtils;
import io.sealights.onpremise.agents.infra.utils.jvm.JvmUtils;
import java.util.List;
import org.slf4j.Logger;

public class BuildAgentBoostraper {
    private static Logger LOG = LogFactory.getLogger(BuildAgentBoostraper.class);
    private ComponentUpgrader buildScannerUpgrader;
    private BuildAgentCliBuilder cliBuilder = new BuildAgentCliBuilder();

    public static boolean isUpgradeEnable() {
        String upgradeEnableProperty = System.getProperty("sl.enableUpgrade");
        return upgradeEnableProperty == null || Boolean.parseBoolean(upgradeEnableProperty);
    }

    public static boolean runRecommendedAgent(UpgradeConfiguration upgradeConfiguration, String[] appArgs) {
        BuildAgentBoostraper instance = new BuildAgentBoostraper(upgradeConfiguration);
        return instance.execute(appArgs);
    }

    public BuildAgentBoostraper(UpgradeConfiguration upgradeConfiguration) {
        this.buildScannerUpgrader = BuildScannerUpgraderFactory.createBootstrapUpgrader(upgradeConfiguration);
    }

    public boolean execute(String[] appArgs) {
        try {
            String jarPathName = this.resolveRecommendedJar();
            if (StringUtils.isNotEmpty(jarPathName)) {
                List<String> cliArgs = this.cliBuilder.execute(appArgs, jarPathName);
                return this.runNewJvm(cliArgs);
            }
            LOG.warn("the recommended jar was not resolved");
        }
        catch (Exception e) {
            LOG.error("the recommended jar not found, error: ", e.getCause());
        }
        return false;
    }

    public String resolveRecommendedJar() throws Exception {
        PropertiesFileReader.tryReadPropertiesFile();
        String recommendedJarLocation = this.buildScannerUpgrader.resolveRecommendedJarPath();
        return recommendedJarLocation;
    }

    public boolean runNewJvm(List<String> cliCommand) {
        LOG.info("Prepare the recommended version to run ");
        return JvmUtils.runNewJvm(cliCommand);
    }
}

