/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.eventservice.proxy.api.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.sealights.onpremise.agents.infra.json.JsonObjectMapper;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;

public final class ContextPropagationTelemetryInfo {
    private static final String DATE_FORMAT_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss'Z'").withZone(ZoneOffset.UTC);
    private final OtelTelemetryInfoAgentType agentType;
    private final SpansRootInfo spans = new SpansRootInfo();
    private final FootprintRequestRootInfo footprintRequests = new FootprintRequestRootInfo();
    private final RawFootprintsRootInfo rawFootprintRequests = new RawFootprintsRootInfo();
    private final CountInfo testColoring = new CountInfo();
    private final SeleniumColorInfo seleniumColor = new SeleniumColorInfo();

    @JsonCreator
    public ContextPropagationTelemetryInfo(@JsonProperty(value="agentType") OtelTelemetryInfoAgentType agentType) {
        this.agentType = agentType;
    }

    public String toString() {
        return JsonObjectMapper.toJson(this);
    }

    public static String getTimeAsString(long unixTimeInMs) {
        return DATE_TIME_FORMATTER.format(Instant.ofEpochMilli(unixTimeInMs));
    }

    @Generated
    public OtelTelemetryInfoAgentType getAgentType() {
        return this.agentType;
    }

    @Generated
    public SpansRootInfo getSpans() {
        return this.spans;
    }

    @Generated
    public FootprintRequestRootInfo getFootprintRequests() {
        return this.footprintRequests;
    }

    @Generated
    public RawFootprintsRootInfo getRawFootprintRequests() {
        return this.rawFootprintRequests;
    }

    @Generated
    public CountInfo getTestColoring() {
        return this.testColoring;
    }

    @Generated
    public SeleniumColorInfo getSeleniumColor() {
        return this.seleniumColor;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextPropagationTelemetryInfo)) {
            return false;
        }
        ContextPropagationTelemetryInfo other = (ContextPropagationTelemetryInfo)o;
        OtelTelemetryInfoAgentType this$agentType = this.getAgentType();
        OtelTelemetryInfoAgentType other$agentType = other.getAgentType();
        if (this$agentType == null ? other$agentType != null : !((Object)((Object)this$agentType)).equals((Object)other$agentType)) {
            return false;
        }
        SpansRootInfo this$spans = this.getSpans();
        SpansRootInfo other$spans = other.getSpans();
        if (this$spans == null ? other$spans != null : !((Object)this$spans).equals(other$spans)) {
            return false;
        }
        FootprintRequestRootInfo this$footprintRequests = this.getFootprintRequests();
        FootprintRequestRootInfo other$footprintRequests = other.getFootprintRequests();
        if (this$footprintRequests == null ? other$footprintRequests != null : !((Object)this$footprintRequests).equals(other$footprintRequests)) {
            return false;
        }
        RawFootprintsRootInfo this$rawFootprintRequests = this.getRawFootprintRequests();
        RawFootprintsRootInfo other$rawFootprintRequests = other.getRawFootprintRequests();
        if (this$rawFootprintRequests == null ? other$rawFootprintRequests != null : !((Object)this$rawFootprintRequests).equals(other$rawFootprintRequests)) {
            return false;
        }
        CountInfo this$testColoring = this.getTestColoring();
        CountInfo other$testColoring = other.getTestColoring();
        if (this$testColoring == null ? other$testColoring != null : !((Object)this$testColoring).equals(other$testColoring)) {
            return false;
        }
        SeleniumColorInfo this$seleniumColor = this.getSeleniumColor();
        SeleniumColorInfo other$seleniumColor = other.getSeleniumColor();
        return !(this$seleniumColor == null ? other$seleniumColor != null : !((Object)this$seleniumColor).equals(other$seleniumColor));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        OtelTelemetryInfoAgentType $agentType = this.getAgentType();
        result = result * 59 + ($agentType == null ? 43 : ((Object)((Object)$agentType)).hashCode());
        SpansRootInfo $spans = this.getSpans();
        result = result * 59 + ($spans == null ? 43 : ((Object)$spans).hashCode());
        FootprintRequestRootInfo $footprintRequests = this.getFootprintRequests();
        result = result * 59 + ($footprintRequests == null ? 43 : ((Object)$footprintRequests).hashCode());
        RawFootprintsRootInfo $rawFootprintRequests = this.getRawFootprintRequests();
        result = result * 59 + ($rawFootprintRequests == null ? 43 : ((Object)$rawFootprintRequests).hashCode());
        CountInfo $testColoring = this.getTestColoring();
        result = result * 59 + ($testColoring == null ? 43 : ((Object)$testColoring).hashCode());
        SeleniumColorInfo $seleniumColor = this.getSeleniumColor();
        result = result * 59 + ($seleniumColor == null ? 43 : ((Object)$seleniumColor).hashCode());
        return result;
    }

    public static final class CountInfo {
        private final AtomicLong count = new AtomicLong();
        private final AtomicLong countDiff = new AtomicLong();
        private final AtomicReference<String> lastTime = new AtomicReference();

        @Generated
        public CountInfo() {
        }

        @Generated
        public AtomicLong getCount() {
            return this.count;
        }

        @Generated
        public AtomicLong getCountDiff() {
            return this.countDiff;
        }

        @Generated
        public AtomicReference<String> getLastTime() {
            return this.lastTime;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CountInfo)) {
                return false;
            }
            CountInfo other = (CountInfo)o;
            AtomicLong this$count = this.getCount();
            AtomicLong other$count = other.getCount();
            if (this$count == null ? other$count != null : !this$count.equals(other$count)) {
                return false;
            }
            AtomicLong this$countDiff = this.getCountDiff();
            AtomicLong other$countDiff = other.getCountDiff();
            if (this$countDiff == null ? other$countDiff != null : !this$countDiff.equals(other$countDiff)) {
                return false;
            }
            AtomicReference<String> this$lastTime = this.getLastTime();
            AtomicReference<String> other$lastTime = other.getLastTime();
            return !(this$lastTime == null ? other$lastTime != null : !this$lastTime.equals(other$lastTime));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtomicLong $count = this.getCount();
            result = result * 59 + ($count == null ? 43 : $count.hashCode());
            AtomicLong $countDiff = this.getCountDiff();
            result = result * 59 + ($countDiff == null ? 43 : $countDiff.hashCode());
            AtomicReference<String> $lastTime = this.getLastTime();
            result = result * 59 + ($lastTime == null ? 43 : $lastTime.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ContextPropagationTelemetryInfo.CountInfo(count=" + this.getCount() + ", countDiff=" + this.getCountDiff() + ", lastTime=" + this.getLastTime() + ")";
        }
    }

    public static final class SeleniumColorInfo {
        private final CountInfo success = new CountInfo();
        private final CountInfo failed = new CountInfo();

        @Generated
        public SeleniumColorInfo() {
        }

        @Generated
        public CountInfo getSuccess() {
            return this.success;
        }

        @Generated
        public CountInfo getFailed() {
            return this.failed;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SeleniumColorInfo)) {
                return false;
            }
            SeleniumColorInfo other = (SeleniumColorInfo)o;
            CountInfo this$success = this.getSuccess();
            CountInfo other$success = other.getSuccess();
            if (this$success == null ? other$success != null : !((Object)this$success).equals(other$success)) {
                return false;
            }
            CountInfo this$failed = this.getFailed();
            CountInfo other$failed = other.getFailed();
            return !(this$failed == null ? other$failed != null : !((Object)this$failed).equals(other$failed));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CountInfo $success = this.getSuccess();
            result = result * 59 + ($success == null ? 43 : ((Object)$success).hashCode());
            CountInfo $failed = this.getFailed();
            result = result * 59 + ($failed == null ? 43 : ((Object)$failed).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ContextPropagationTelemetryInfo.SeleniumColorInfo(success=" + this.getSuccess() + ", failed=" + this.getFailed() + ")";
        }
    }

    public static final class RawFootprintsRootInfo {
        private final CountInfo flushed = new CountInfo();
        private final CountInfo dropBecauseUnresolvedExecution = new CountInfo();
        private final CountInfo dropBecauseEndedExecution = new CountInfo();

        @Generated
        public RawFootprintsRootInfo() {
        }

        @Generated
        public CountInfo getFlushed() {
            return this.flushed;
        }

        @Generated
        public CountInfo getDropBecauseUnresolvedExecution() {
            return this.dropBecauseUnresolvedExecution;
        }

        @Generated
        public CountInfo getDropBecauseEndedExecution() {
            return this.dropBecauseEndedExecution;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RawFootprintsRootInfo)) {
                return false;
            }
            RawFootprintsRootInfo other = (RawFootprintsRootInfo)o;
            CountInfo this$flushed = this.getFlushed();
            CountInfo other$flushed = other.getFlushed();
            if (this$flushed == null ? other$flushed != null : !((Object)this$flushed).equals(other$flushed)) {
                return false;
            }
            CountInfo this$dropBecauseUnresolvedExecution = this.getDropBecauseUnresolvedExecution();
            CountInfo other$dropBecauseUnresolvedExecution = other.getDropBecauseUnresolvedExecution();
            if (this$dropBecauseUnresolvedExecution == null ? other$dropBecauseUnresolvedExecution != null : !((Object)this$dropBecauseUnresolvedExecution).equals(other$dropBecauseUnresolvedExecution)) {
                return false;
            }
            CountInfo this$dropBecauseEndedExecution = this.getDropBecauseEndedExecution();
            CountInfo other$dropBecauseEndedExecution = other.getDropBecauseEndedExecution();
            return !(this$dropBecauseEndedExecution == null ? other$dropBecauseEndedExecution != null : !((Object)this$dropBecauseEndedExecution).equals(other$dropBecauseEndedExecution));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CountInfo $flushed = this.getFlushed();
            result = result * 59 + ($flushed == null ? 43 : ((Object)$flushed).hashCode());
            CountInfo $dropBecauseUnresolvedExecution = this.getDropBecauseUnresolvedExecution();
            result = result * 59 + ($dropBecauseUnresolvedExecution == null ? 43 : ((Object)$dropBecauseUnresolvedExecution).hashCode());
            CountInfo $dropBecauseEndedExecution = this.getDropBecauseEndedExecution();
            result = result * 59 + ($dropBecauseEndedExecution == null ? 43 : ((Object)$dropBecauseEndedExecution).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ContextPropagationTelemetryInfo.RawFootprintsRootInfo(flushed=" + this.getFlushed() + ", dropBecauseUnresolvedExecution=" + this.getDropBecauseUnresolvedExecution() + ", dropBecauseEndedExecution=" + this.getDropBecauseEndedExecution() + ")";
        }
    }

    public static final class FootprintRequestRootInfo {
        private final CountInfo colored = new CountInfo();
        private final CountInfo anon = new CountInfo();

        @Generated
        public FootprintRequestRootInfo() {
        }

        @Generated
        public CountInfo getColored() {
            return this.colored;
        }

        @Generated
        public CountInfo getAnon() {
            return this.anon;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FootprintRequestRootInfo)) {
                return false;
            }
            FootprintRequestRootInfo other = (FootprintRequestRootInfo)o;
            CountInfo this$colored = this.getColored();
            CountInfo other$colored = other.getColored();
            if (this$colored == null ? other$colored != null : !((Object)this$colored).equals(other$colored)) {
                return false;
            }
            CountInfo this$anon = this.getAnon();
            CountInfo other$anon = other.getAnon();
            return !(this$anon == null ? other$anon != null : !((Object)this$anon).equals(other$anon));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CountInfo $colored = this.getColored();
            result = result * 59 + ($colored == null ? 43 : ((Object)$colored).hashCode());
            CountInfo $anon = this.getAnon();
            result = result * 59 + ($anon == null ? 43 : ((Object)$anon).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ContextPropagationTelemetryInfo.FootprintRequestRootInfo(colored=" + this.getColored() + ", anon=" + this.getAnon() + ")";
        }
    }

    public static final class SpansNestedInfo {
        private final CountInfo opened = new CountInfo();
        private final CountInfo ended = new CountInfo();

        @Generated
        public SpansNestedInfo() {
        }

        @Generated
        public CountInfo getOpened() {
            return this.opened;
        }

        @Generated
        public CountInfo getEnded() {
            return this.ended;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpansNestedInfo)) {
                return false;
            }
            SpansNestedInfo other = (SpansNestedInfo)o;
            CountInfo this$opened = this.getOpened();
            CountInfo other$opened = other.getOpened();
            if (this$opened == null ? other$opened != null : !((Object)this$opened).equals(other$opened)) {
                return false;
            }
            CountInfo this$ended = this.getEnded();
            CountInfo other$ended = other.getEnded();
            return !(this$ended == null ? other$ended != null : !((Object)this$ended).equals(other$ended));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            CountInfo $opened = this.getOpened();
            result = result * 59 + ($opened == null ? 43 : ((Object)$opened).hashCode());
            CountInfo $ended = this.getEnded();
            result = result * 59 + ($ended == null ? 43 : ((Object)$ended).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ContextPropagationTelemetryInfo.SpansNestedInfo(opened=" + this.getOpened() + ", ended=" + this.getEnded() + ")";
        }
    }

    public static final class SpansRootInfo {
        private final SpansNestedInfo withBaggage = new SpansNestedInfo();
        private final SpansNestedInfo withoutBaggage = new SpansNestedInfo();
        private final AtomicLong activeSpans = new AtomicLong();

        @Generated
        public SpansRootInfo() {
        }

        @Generated
        public SpansNestedInfo getWithBaggage() {
            return this.withBaggage;
        }

        @Generated
        public SpansNestedInfo getWithoutBaggage() {
            return this.withoutBaggage;
        }

        @Generated
        public AtomicLong getActiveSpans() {
            return this.activeSpans;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpansRootInfo)) {
                return false;
            }
            SpansRootInfo other = (SpansRootInfo)o;
            SpansNestedInfo this$withBaggage = this.getWithBaggage();
            SpansNestedInfo other$withBaggage = other.getWithBaggage();
            if (this$withBaggage == null ? other$withBaggage != null : !((Object)this$withBaggage).equals(other$withBaggage)) {
                return false;
            }
            SpansNestedInfo this$withoutBaggage = this.getWithoutBaggage();
            SpansNestedInfo other$withoutBaggage = other.getWithoutBaggage();
            if (this$withoutBaggage == null ? other$withoutBaggage != null : !((Object)this$withoutBaggage).equals(other$withoutBaggage)) {
                return false;
            }
            AtomicLong this$activeSpans = this.getActiveSpans();
            AtomicLong other$activeSpans = other.getActiveSpans();
            return !(this$activeSpans == null ? other$activeSpans != null : !this$activeSpans.equals(other$activeSpans));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SpansNestedInfo $withBaggage = this.getWithBaggage();
            result = result * 59 + ($withBaggage == null ? 43 : ((Object)$withBaggage).hashCode());
            SpansNestedInfo $withoutBaggage = this.getWithoutBaggage();
            result = result * 59 + ($withoutBaggage == null ? 43 : ((Object)$withoutBaggage).hashCode());
            AtomicLong $activeSpans = this.getActiveSpans();
            result = result * 59 + ($activeSpans == null ? 43 : $activeSpans.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ContextPropagationTelemetryInfo.SpansRootInfo(withBaggage=" + this.getWithBaggage() + ", withoutBaggage=" + this.getWithoutBaggage() + ", activeSpans=" + this.getActiveSpans() + ")";
        }
    }

    public static enum OtelTelemetryInfoAgentType {
        javaTestListener,
        javaTestRunner;

    }
}

