/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.eventservice.proxy.api.types;

import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.IAgentEventType;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class AgentEventTypeRegistry {
    private static final String[] KNOWN_EVENT_TYPE_CLASSES = new String[]{"io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEventCode", "io.sealights.onpremise.agents.events.cockpit.TestListenerEventTypes"};
    private static final Map<Integer, IAgentEventType> codeToAgentEventMap = new HashMap<Integer, IAgentEventType>();

    public static void registerAgentEventTypeClass(Class<? extends IAgentEventType> agentEventCode) {
        if (agentEventCode.isEnum()) {
            for (IAgentEventType enumConstant : agentEventCode.getEnumConstants()) {
                codeToAgentEventMap.put(enumConstant.getCode(), enumConstant);
            }
        }
    }

    public static IAgentEventType resolveByCode(int code) {
        return codeToAgentEventMap.get(code);
    }

    public static <T> T resolveByCode(int code, Class<T> eventClass) {
        return eventClass.cast(codeToAgentEventMap.get(code));
    }

    public static <T> T resolveByType(IAgentEventType type, Class<T> eventClass) {
        return AgentEventTypeRegistry.resolveByCode(type.getCode(), eventClass);
    }

    private static void tryLoadKnownEventTypeClasses() {
        for (String knownEventClass : KNOWN_EVENT_TYPE_CLASSES) {
            AgentEventTypeRegistry.tryLoadKnownEventTypeClass(knownEventClass).ifPresent(AgentEventTypeRegistry::registerAgentEventTypeClass);
        }
    }

    private static Optional<Class<IAgentEventType>> tryLoadKnownEventTypeClass(String knownEventTypeClass) {
        try {
            return Optional.ofNullable(Class.forName(knownEventTypeClass));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    static {
        AgentEventTypeRegistry.tryLoadKnownEventTypeClasses();
    }
}

