/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.eventservice.proxy.api.types;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonValue;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentEventTypeRegistry;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentStartedEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AnonymousExecutionEvents;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.ConfigChangedEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.ContextPropagationTelemetryEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.ExecutionIdEvents;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.FootprintsQueueOverflowEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.GenericAgentEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.GitEvents;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.IAgentEventType;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.PingDataEvents;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.SimpleEvents;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.StringCollectionDataEvent;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.StringDataEvents;

public enum AgentEventCode implements IAgentEventType
{
    GENERIC_AGENT_EVENT(1000, GenericAgentEvent.class),
    AGENT_STARTED(1001, AgentStartedEvent.class),
    AGENT_SHUTDOWN(1002, PingDataEvents.AgentShutdownEvent.class),
    AGENT_PING(1003, PingDataEvents.PingDataEvent.class),
    AGENT_CONFIG_CHANGED(1004, ConfigChangedEvent.class),
    FIRST_COVERAGE_INSTRUMENTATION_PERFORMED(1005, SimpleEvents.FirstCoveragePerformedEvent.class),
    ANONYMOUS_EXECUTION_FOUND(1006, AnonymousExecutionEvents.AnonymousExecutionFoundEvent.class),
    ANONYMOUS_EXECUTION_NOT_FOUND(1007, AnonymousExecutionEvents.AnonymousExecutionNotFoundEvent.class),
    AGENT_MUTED(1008, SimpleEvents.AgentMutedEvent.class),
    AGENT_UNMUTED(1009, SimpleEvents.AgentUnmutedEvent.class),
    FIRST_FOOTPRINTS_ADDED_TO_BUFFER(1010, SimpleEvents.FirstFootprintsAddedToBufferEvent.class),
    EXECUTION_ID_CREATED(1012, ExecutionIdEvents.ExecutionIdCreatedEvent.class),
    EXECUTION_ID_DELETED(1013, ExecutionIdEvents.ExecutionIdDeletedEvent.class),
    CONTEXT_PROPAGATION_TELEMETRY(1019, ContextPropagationTelemetryEvent.class),
    GENERIC_MESSAGE(2000, StringDataEvents.GenericMessageEvent.class),
    GENERIC_MESSAGE_SUPERUSER(2999, StringDataEvents.GenericMessageSuperUserEvent.class),
    GENERIC_WARNING(3000, StringDataEvents.GenericWarningEvent.class),
    AGENT_DID_NOT_SHUTDOWN(3001, GenericAgentEvent.class),
    AGENT_FOOTPRINTS_QUEUE_FULL_SUPERUSER(3004, FootprintsQueueOverflowEvent.class),
    SOME_EXECUTION_NOT_RESOLVED_BEFORE_SHUTDOWN(3008, StringCollectionDataEvent.SomeExecutionsNotResolvedBeforeShutdownWarningEvent.class),
    PER_THREAD_COVERAGE_DISABLED(3010, StringDataEvents.PerThreadCoverageDisabledWarning.class),
    TIME_SYNC_FAILED(3011, StringDataEvents.TimeSyncFailedWarning.class),
    GENERIC_WARNING_SUPERUSER(3999, StringDataEvents.GenericWarningSuperUserEvent.class),
    GENERIC_ERROR(4000, StringDataEvents.GenericErrorEvent.class),
    DUPLICATE_MODULE(4001, StringDataEvents.GenericErrorEvent.class),
    DATA_PROCESSOR_NO_EXECUTIONS(4002, StringDataEvents.GenericErrorEvent.class),
    DATA_PROCESSOR_INVALID_FORMAT(4003, StringDataEvents.GenericErrorEvent.class),
    DATA_PROCESSOR_EMPTY_DATA(4004, StringDataEvents.GenericErrorEvent.class),
    BUILD_MAP_SUBMISSION_ERROR(4005, StringDataEvents.BuildMapSubmitErrorEvent.class),
    FOOTPRINTS_SUBMISSION_ERROR(4006, StringDataEvents.GenericErrorEvent.class),
    TEST_EVENTS_SUBMISSION_ERROR(4007, StringDataEvents.TestEventsSubmitErrorEvent.class),
    EXTERNAL_DATA_PROCESSOR_SUBMISSION_ERROR(4008, StringDataEvents.ExternalDataSubmitErrorEvent.class),
    UNSUPPORTED_OS(4009, StringDataEvents.GenericErrorEvent.class),
    UNSUPPORTED_RUNTIME(4010, StringDataEvents.GenericErrorEvent.class),
    THIRD_PARTY_PACKAGE_DETECTED(4011, StringDataEvents.GenericErrorEvent.class),
    THIRD_PARTY_FILE_DETECTED(4012, StringDataEvents.GenericErrorEvent.class),
    FAILED_TO_CREATE_EXECUTION_ERROR(4016, StringDataEvents.FailedToCreateExecutionError.class),
    INVALID_CONFIGURATION_AGENT_DISABLED(4020, StringCollectionDataEvent.InvalidConfigurationAgentDisabledErrorEvent.class),
    FAILED_TO_SYNC_LOCAL_TIME(4050, StringDataEvents.GenericErrorEvent.class),
    GENERIC_ERROR_SUPERUSER(4999, StringDataEvents.GenericErrorSuperUserEvent.class),
    GIT_INFO(2500, GitEvents.GitInfoEvent.class),
    GIT_VERSION(2501, GitEvents.GitVersionEvent.class),
    GIT_CONFIGURATION(2502, GitEvents.GitConfigurationEvent.class),
    GIT_DEBUG(5500, GitEvents.GitDebugEvent.class),
    GIT_WARNING(3500, GitEvents.GitWarningEvent.class),
    GIT_ERROR(4500, GitEvents.GitErrorEvent.class),
    LEAST_VERBOSE_LOG(5001, GenericAgentEvent.class),
    MOST_VERBOSE_LOG(5999, GenericAgentEvent.class);

    private final int code;
    private final Class<? extends AgentEvent> eventClass;

    private AgentEventCode(int code, Class<? extends AgentEvent> eventClass) {
        this.code = code;
        this.eventClass = eventClass;
    }

    @Override
    @JsonValue
    public int getCode() {
        return this.code;
    }

    @Override
    @JsonIgnore
    public Class<? extends AgentEvent> getEventClass() {
        return this.eventClass;
    }

    public String toString() {
        return String.format("%s(%d)", this.name(), this.code);
    }

    static {
        AgentEventTypeRegistry.registerAgentEventTypeClass(AgentEventCode.class);
    }
}

