/*
 * Decompiled with CFR 0.152.
 */
package io.sealights.onpremise.agentevents.engine.builders;

import io.sealights.onpremise.agentevents.engine.builders.InfoBuilder;
import io.sealights.onpremise.agentevents.eventservice.proxy.api.types.AgentStartInfo;
import io.sealights.onpremise.agents.infra.configuration.SLPropertiesFilter;
import io.sealights.onpremise.agents.infra.configuration.SystemPropertiesHelper;
import io.sealights.onpremise.agents.infra.env.JvmEnvInfoCollector;
import io.sealights.onpremise.agents.infra.token.TokenValueFormatter;
import java.util.HashMap;
import java.util.Properties;

class JavaEnvInfoBuilder
extends InfoBuilder<AgentStartInfo.JavaEnvInfo> {
    boolean maskSensitiveData = SystemPropertiesHelper.getBoolProperty("sl.maskData", false);

    JavaEnvInfoBuilder() {
        this.data = new AgentStartInfo.JavaEnvInfo();
    }

    @Override
    protected AgentStartInfo.JavaEnvInfo getEmptyData() {
        return (AgentStartInfo.JavaEnvInfo)this.data;
    }

    @Override
    protected void fillData() {
        ((AgentStartInfo.JavaEnvInfo)this.data).setJavaVendor(JvmEnvInfoCollector.getJavaVendor());
        ((AgentStartInfo.JavaEnvInfo)this.data).setJavaVersion(JvmEnvInfoCollector.getJavaVersion());
        ((AgentStartInfo.JavaEnvInfo)this.data).setJvmName(JvmEnvInfoCollector.getJvmName());
        HashMap<String, String> propMap = new HashMap<String, String>();
        Properties slProps = SLPropertiesFilter.getAll();
        for (String key : slProps.stringPropertyNames()) {
            propMap.put(key, this.maskSensitiveValues(key, slProps.getProperty(key)));
        }
        ((AgentStartInfo.JavaEnvInfo)this.data).setSystemProps(propMap);
    }

    private String maskSensitiveValues(String variableName, String value) {
        if (this.maskSensitiveData) {
            if (variableName.contains("token") && !variableName.contains("tokenFile")) {
                return TokenValueFormatter.truncateTokenArgValue(value);
            }
            if (variableName.contains("proxy")) {
                return "<real value removed due to security configuration>";
            }
        }
        return value;
    }
}

